/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.ext;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.hibernate.console.ext.HibernateExtensionDefinition;

public class HibernateExtensionManager {
    public static final String HIBERNATEEXTENSION_EXTENSION_ID = "org.hibernate.eclipse.hibernateextension";
    private static Map<String, HibernateExtensionDefinition> hibernateExtensions;

    private static IExtension[] findExtensions(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static HibernateExtensionDefinition[] findHiberanteExtensionDefinitions() {
        ArrayList<HibernateExtensionDefinition> hibernateExtensions = new ArrayList<HibernateExtensionDefinition>();
        IExtension[] extensions = HibernateExtensionManager.findExtensions(HIBERNATEEXTENSION_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                HibernateExtensionDefinition extensiodDefinition = new HibernateExtensionDefinition(elements[j]);
                hibernateExtensions.add(extensiodDefinition);
                ++j;
            }
            ++i;
        }
        return hibernateExtensions.toArray(new HibernateExtensionDefinition[hibernateExtensions.size()]);
    }

    public static synchronized Map<String, HibernateExtensionDefinition> getHibernateExtensionDefinitionsAsMap() {
        if (hibernateExtensions == null) {
            hibernateExtensions = new TreeMap<String, HibernateExtensionDefinition>();
            HibernateExtensionDefinition[] findExporterDefinitions = HibernateExtensionManager.findHiberanteExtensionDefinitions();
            int i = 0;
            while (i < findExporterDefinitions.length) {
                HibernateExtensionDefinition exporterDefinition = findExporterDefinitions[i];
                hibernateExtensions.put(exporterDefinition.getHibernateVersion(), exporterDefinition);
                ++i;
            }
        }
        return hibernateExtensions;
    }

    public static HibernateExtensionDefinition findHibernateExtensionDefinition(String hibernateVersion) {
        return HibernateExtensionManager.getHibernateExtensionDefinitionsAsMap().get(hibernateVersion);
    }
}

