/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.QueryPage;
import org.hibernate.console.ext.HibernateExtension;

public abstract class AbstractQueryPage
implements QueryPage {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private int id;
    private Object session;
    private final HibernateExtension extension;
    protected List<Object> list;
    protected long queryTime = -1L;
    protected boolean sticky = true;
    protected List<Throwable> exceptions = new ArrayList<Throwable>();
    protected String tabName;
    protected QueryInputModel model;

    @Override
    public void setId(int i) {
        this.id = i;
    }

    @Override
    public int getResultSize() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public AbstractQueryPage(HibernateExtension extension, QueryInputModel model) {
        this.extension = extension;
        this.model = model;
    }

    @Override
    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    @Override
    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public Object getSession() {
        return this.session;
    }

    @Override
    public void setSession(Object s) {
        this.session = s;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addException(Throwable e) {
        this.exceptions.add(e);
        this.release();
        this.pcs.firePropertyChange("exceptions", null, this.exceptions);
    }

    @Override
    public HibernateExtension getHibernateExtension() {
        return this.extension;
    }

    @Override
    public long getQueryTime() {
        return this.queryTime;
    }

    @Override
    public String getTabName() {
        return this.tabName;
    }

    @Override
    public void setTabName(String tabName) {
        String oldValue = this.tabName;
        this.tabName = tabName;
        this.pcs.firePropertyChange("tabName", oldValue, tabName);
    }

    @Override
    public void setModel(QueryInputModel model) {
        this.model = model;
    }
}

