/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class HQLPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String HQL_DEFAULT = "__default_hql_block__";
    public static final String HQL_COMMENT = "__hql_comment__";
    public static final String HQL_QUOTED_LITERAL = "__hql_quoted_literal__";
    public static final String HQL_DELIMITED_IDENTIFIER = "__hql_delimited_identifier__";
    public static final String HQL_SELECT = "__hql_select_statement__";
    public static final String HQL_INSERT = "__hql_insert_statement__";
    public static final String HQL_UPDATE = "__hql_update_statement__";
    public static final String HQL_DELETE = "__hql_delete_statement__";
    public static final String HQL_MERGE = "__hql_merge_statement__";
    public static final String HQL_CREATE = "__hql_create_statement__";
    public static final String HQL_DROP = "__hql_drop_statement__";
    public static final String HQL_ALTER = "__hql_alter_statement__";
    public static final String HQL_GRANT = "__hql_grant_statement__";
    public static final String HQL_REVOKE = "__hql_revoke_statement__";
    public static final String HQL_COMMIT = "__hql_commit_statement__";
    public static final String HQL_ROLLBACK = "__hql_rollback_statement__";
    public static final String HQL_SET = "__hql_set_statement__";
    public static final String HQL_CONNECT = "__hql_connect_statement__";
    public static final String HQL_DISCONNECT = "__hql_disconnect_statement__";
    public static final String HQL_COMMENT_ON = "__hql_comment_on_statement__";
    public static final String HQL_TERMINATE = "__hql_terminate_statement__";
    public static final String HQL_CATALOG = "__hql_catalog_statement__";
    public static final String HQL_UNCATALOG = "__hql_uncatalog_statement__";
    public static final String HQL_SIGNAL = "__hql_signal_statement__";
    public static final String HQL_UNKNOWNHQL = "__hql__unknownhql_statement__";
    public static final String[] HQL_PARTITION_TYPES = new String[]{"__hql_comment__", "__hql_quoted_literal__", "__hql_delimited_identifier__"};

    public static ITypedRegion[] getDocumentRegions(IDocument doc) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)doc, (String)"__hql_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
        }
        catch (BadLocationException badLocationException) {}
        return regions;
    }

    public HQLPartitionScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("--", (IToken)new Token((Object)HQL_COMMENT)));
        rules.add(new SingleLineRule("'", "'", (IToken)new Token((Object)HQL_QUOTED_LITERAL), '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)new Token((Object)HQL_DELIMITED_IDENTIFIER), '\\'));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }
}

