/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.query.list;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.TreeItem;

public class TreeItemSelectionManager {
    TreeViewer treeViewer = null;
    Listener listener = null;
    int lock = 0;

    public TreeItemSelectionManager(TreeViewer treeViewer, Listener listener) {
        this.listener = listener;
        this.treeViewer = treeViewer;
        this.update();
        treeViewer.getTree().addKeyListener((KeyListener)new KL());
        treeViewer.getTree().addSelectionListener((SelectionListener)new SL());
        treeViewer.getTree().addTreeListener((TreeListener)new EL());
    }

    public void update() {
        this.update(this.treeViewer.getTree().getItems());
    }

    void update(TreeItem[] is) {
        ++this.lock;
        try {
            int i = 0;
            while (i < is.length) {
                is[i].getData();
                is[i].setChecked(this.listener.isSelected(is[i].getData()));
                this.update(is[i].getItems());
                ++i;
            }
        }
        finally {
            --this.lock;
        }
    }

    class EL
    implements TreeListener {
        EL() {
        }

        public void treeCollapsed(TreeEvent e) {
        }

        public void treeExpanded(TreeEvent e) {
            if (e.item instanceof TreeItem) {
                TreeItem item = (TreeItem)e.item;
                TreeItem[] is = item.getItems();
                TreeItemSelectionManager.this.update(is);
            }
        }
    }

    class KL
    extends KeyAdapter {
        KL() {
        }

        public void keyPressed(KeyEvent e) {
            boolean flip;
            boolean bl = flip = e.keyCode == 32;
            if (flip) {
                TreeItem[] items = TreeItemSelectionManager.this.treeViewer.getTree().getSelection();
                TreeItem item = items == null || items.length == 0 ? null : items[0];
                TreeItemSelectionManager.this.listener.flip(item);
            }
        }
    }

    public static interface Listener {
        public void flip(TreeItem var1);

        public boolean isSelected(Object var1);
    }

    class SL
    implements SelectionListener {
        SL() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.item instanceof TreeItem) {
                if (TreeItemSelectionManager.this.lock > 0) {
                    return;
                }
                ++TreeItemSelectionManager.this.lock;
                try {
                    TreeItem item = (TreeItem)e.item;
                    if (TreeItemSelectionManager.this.listener.isSelected(item.getData()) != item.getChecked()) {
                        TreeItemSelectionManager.this.listener.flip(item);
                    }
                    if (TreeItemSelectionManager.this.listener.isSelected(item.getData()) != item.getChecked()) {
                        item.setChecked(TreeItemSelectionManager.this.listener.isSelected(item.getData()));
                    }
                }
                finally {
                    --TreeItemSelectionManager.this.lock;
                }
            }
        }
    }
}

