/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.query;

import java.util.Properties;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryDialog;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.model.ui.wizards.query.IQueryDialog;

public class AbstractQueryWizard
implements SpecialWizard {
    private AbstractQueryWizardView view = null;

    public void dispose() {
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = null;
    }

    public void setView(AbstractQueryWizardView view) {
        this.view = view;
    }

    public AbstractQueryWizardView getView() {
        return this.view;
    }

    public void setObject(Object object) {
        String key;
        this.view.setModel(this.findModel(object));
        this.view.setObject(object);
        Properties p = this.findProperties(object);
        String string = key = p == null ? null : p.getProperty("help");
        if (key != null) {
            String title = p.getProperty("title");
            if (title == null) {
                title = WizardKeys.getHeader((String)key);
            }
            if (title == null) {
                title = WizardKeys.getHeader((String)"Properties");
            }
            if (title == null) {
                title = "Title is not found for key \"" + key + "\"";
            }
            this.view.setWindowTitle(title);
            String subtitle = p.getProperty("subtitle");
            if (subtitle == null) {
                subtitle = WizardKeys.getTitle((String)key);
            }
            if (subtitle == null) {
                subtitle = "Subtitle is not found for key \"" + key + "\"";
            }
            this.view.setTitle(subtitle);
            String message = p.getProperty("message");
            if (message == null) {
                message = WizardKeys.getString((String)(String.valueOf(key) + ".Message"));
            }
            if (message != null) {
                this.view.setMessage(message);
            }
        }
    }

    private Properties findProperties(Object o) {
        if (o instanceof Properties) {
            return (Properties)o;
        }
        if (!(o instanceof Object[])) {
            return null;
        }
        Object[] os = (Object[])o;
        int i = 0;
        while (i < os.length) {
            if (os[i] instanceof Properties) {
                return (Properties)os[i];
            }
            ++i;
        }
        return null;
    }

    private XModel findModel(Object o) {
        Properties p;
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            int i = 0;
            while (i < os.length) {
                if (os[i] instanceof XModel) {
                    return (XModel)os[i];
                }
                if (os[i] instanceof XModelObject) {
                    return ((XModelObject)os[i]).getModel();
                }
                ++i;
            }
        }
        if ((p = this.findProperties(o)) != null) {
            Object q = p.get("model");
            if (q instanceof XModel) {
                return (XModel)q;
            }
            q = p.get("object");
            if (q instanceof XModelObject) {
                return ((XModelObject)q).getModel();
            }
        }
        return null;
    }

    public int execute() {
        Shell shell = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        IQueryDialog dialog = this.createDialog(shell);
        dialog.getDialog().open();
        return this.view.code();
    }

    public IQueryDialog createDialog(Shell shell) {
        AbstractQueryDialog dialog = new AbstractQueryDialog(shell);
        this.setUpDialog(dialog);
        return dialog;
    }

    protected final void setUpDialog(IQueryDialog dialog) {
        dialog.setView(this.view);
        dialog.getDialog().create();
        this.view.setDialog(dialog.getDialog());
    }

    public static class Property {
        public static final String HELP = "help";
        public static final String MODAL = "modal";
        public static final String TITLE = "title";
        public static final String SUBTITLE = "subtitle";
        public static final String MESSAGE = "message";
        public static final String BLOCKING = "blocking";
    }
}

