/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.util;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class StringUtilities {
    public static int getStringWidth(Drawable drawable, Font font, String str) {
        GC gc = new GC(drawable);
        gc.setFont(font);
        int width = gc.stringExtent((String)str).x;
        gc.dispose();
        return width;
    }

    public static int getStringWidth(Control control, String str) {
        return StringUtilities.getStringWidth((Drawable)control, control.getFont(), str);
    }

    public static String makeShortString(String source, int width, String sufix, Drawable drawable, Font font) {
        String str;
        GC gc = new GC(drawable);
        gc.setFont(font);
        if (source == null) {
            source = "";
        }
        if (gc.stringExtent((String)source).x > width) {
            if (sufix == null) {
                sufix = "";
            }
            str = sufix;
            int i = 0;
            while (i < source.length()) {
                String tmp = String.valueOf(source.substring(0, i)) + sufix;
                if (gc.stringExtent((String)tmp).x <= width) {
                    str = tmp;
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            str = source;
        }
        gc.dispose();
        return str;
    }

    public static String makeShortString(String source, int width, String sufix, Control control) {
        return StringUtilities.makeShortString(source, width, sufix, (Drawable)control, control.getFont());
    }

    public static String dottedString(String source, int width, Drawable drawable, Font font) {
        return StringUtilities.makeShortString(source, width, "...", drawable, font);
    }

    public static String dottedString(String source, int width, Control control) {
        return StringUtilities.dottedString(source, width, (Drawable)control, control.getFont());
    }
}

