/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.swt.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BorderLayout
extends Layout {
    public int northHeight = -1;
    public int southHeight = -1;
    public int westWidth = -1;
    public int eastWidth = -1;
    public Control centerComposite = null;
    public Control northComposite = null;
    public Control southComposite = null;
    public Control westComposite = null;
    public Control eastComposite = null;

    private void validate() {
        if (this.northComposite != null && this.northComposite.isDisposed()) {
            this.northComposite = null;
        }
        if (this.westComposite != null && this.westComposite.isDisposed()) {
            this.westComposite = null;
        }
        if (this.southComposite != null && this.southComposite.isDisposed()) {
            this.southComposite = null;
        }
        if (this.eastComposite != null && this.eastComposite.isDisposed()) {
            this.eastComposite = null;
        }
        if (this.centerComposite != null && this.centerComposite.isDisposed()) {
            this.centerComposite = null;
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        this.validate();
        int width = 0;
        int height = 0;
        int ewHeight = 0;
        if (this.northComposite != null) {
            height = this.northHeight == -1 ? (height += this.northComposite.computeSize((int)wHint, (int)-1).y) : (height += this.northHeight);
        }
        if (this.southComposite != null) {
            height = this.southHeight == -1 ? (height += this.southComposite.computeSize((int)wHint, (int)-1).y) : (height += this.southHeight);
        }
        if (this.westComposite != null) {
            width = this.westWidth == -1 ? (width += this.westComposite.computeSize((int)-1, (int)hHint).x) : (width += this.westWidth);
            ewHeight = this.westComposite.computeSize((int)-1, (int)hHint).y;
        }
        if (this.eastComposite != null) {
            width = this.eastWidth == -1 ? (width += this.eastComposite.computeSize((int)-1, (int)hHint).x) : (width += this.eastWidth);
            int eH = this.eastComposite.computeSize((int)-1, (int)hHint).y;
            if (eH > ewHeight) {
                ewHeight = eH;
            }
        }
        if (this.centerComposite != null) {
            width += this.centerComposite.computeSize((int)-1, (int)-1).x;
            int ch = this.centerComposite.computeSize((int)-1, (int)-1).y;
            if (ewHeight < ch) {
                ewHeight = ch;
            }
        }
        return new Point(width, height += ewHeight);
    }

    protected void layout(Composite composite, boolean flushCache) {
        int x = composite.getClientArea().x;
        int y = composite.getClientArea().y;
        int width = composite.getClientArea().width;
        int height = composite.getClientArea().height;
        int remWidth = width;
        int remHeight = height;
        int remX = composite.getClientArea().x;
        int remY = composite.getClientArea().y;
        if (this.northComposite != null) {
            int nH = this.northHeight == -1 ? this.northComposite.computeSize((int)width, (int)-1).y : this.northHeight;
            this.northComposite.setBounds(x, y, width, nH);
            remHeight -= nH;
            remY += nH;
        }
        if (this.southComposite != null) {
            int sH = this.southHeight == -1 ? this.southComposite.computeSize((int)width, (int)-1).y : this.southHeight;
            this.southComposite.setBounds(x, y + height - sH, width, sH);
            remHeight -= sH;
        }
        if (this.westComposite != null) {
            int wW = this.westWidth == -1 ? this.westComposite.computeSize((int)-1, (int)height).x : this.westWidth;
            this.westComposite.setBounds(x, remY, wW, remHeight);
            remWidth -= wW;
            remX += wW;
        }
        if (this.eastComposite != null) {
            int eW = this.eastWidth == -1 ? this.eastComposite.computeSize((int)-1, (int)height).x : this.eastWidth;
            this.eastComposite.setBounds(x + width - eW, remY, eW, remHeight);
            remWidth -= eW;
        }
        if (this.centerComposite != null) {
            this.centerComposite.setBounds(remX, remY, remWidth, remHeight);
        }
    }
}

