/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.dialog;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MessageAndCheckboxDialog
extends MessageDialog {
    public static String MESSAGE = "message";
    public static String CHECKBOX_MESSAGE = "checkboxMessage";
    public static String CHECKED = "checked";
    public static String BUTTONS = "buttons";
    public static String SEPARATOR = "separator";
    public static String TITLE = "title";
    public static String RETURN_CODE = "returnCode";
    Button button;
    Button[] buttons = new Button[0];
    Properties properties;
    int lastButton = -1;

    public MessageAndCheckboxDialog(Shell parentShell, String dialogTitle, int dialogImageType, Properties p) {
        super(parentShell, dialogTitle, null, p.getProperty(MESSAGE), dialogImageType, MessageAndCheckboxDialog.createButtonLabels(p), 0);
        this.properties = p;
    }

    static String[] createButtonLabels(Properties p) {
        String[] buttons = (String[])p.get(BUTTONS);
        if (buttons == null) {
            return new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        }
        String[] bs = new String[buttons.length];
        int i = 0;
        while (i < bs.length) {
            bs[i] = JFaceResources.getString((String)buttons[i]);
            if (bs[i] == null) {
                bs[i] = buttons[i];
            }
            ++i;
        }
        return bs;
    }

    public static boolean openConfirm(Shell parent, Properties p) {
        Assert.isNotNull((Object)p);
        Assert.isNotNull((Object)p.getProperty(MESSAGE), (String)("Property " + MESSAGE + " is null"));
        Assert.isNotNull((Object)p.getProperty(CHECKBOX_MESSAGE), (String)("Property " + CHECKBOX_MESSAGE + " is null"));
        Assert.isTrue((boolean)(p.get(CHECKED) instanceof Boolean), (String)("Property " + CHECKED + " must have type Boolean"));
        String title = p.getProperty("title", "Confirmation");
        MessageAndCheckboxDialog dialog = new MessageAndCheckboxDialog(parent, title, 3, p);
        int result = dialog.open();
        p.put(RETURN_CODE, (Object)result);
        return result == 0;
    }

    protected Control createCustomArea(Composite parent) {
        String b1 = this.properties.getProperty(String.valueOf(CHECKBOX_MESSAGE) + "_1");
        if (b1 == null) {
            this.button = this.createCheckBox(parent, "");
            return this.button;
        }
        return this.createMultiCheckBox(parent);
    }

    protected Button createCheckBox(Composite parent, String suffix) {
        Button b = new Button(parent, 32);
        GridData data = new GridData(768);
        if (this.getImage() != null) {
            data.horizontalIndent = this.getImage().getImageData().width + 8;
        }
        b.setLayoutData((Object)data);
        b.setText(this.properties.getProperty(String.valueOf(CHECKBOX_MESSAGE) + suffix));
        b.setSelection(((Boolean)this.properties.get(String.valueOf(CHECKED) + suffix)).booleanValue());
        return b;
    }

    protected Control createMultiCheckBox(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(768));
        GridLayout l = new GridLayout();
        l.marginWidth = 0;
        l.marginHeight = 11;
        c.setLayout((Layout)l);
        this.button = this.createCheckBox(c, "");
        ArrayList<Button> list = new ArrayList<Button>();
        int i = 1;
        while (true) {
            String suffix = "_" + i;
            if (this.properties.getProperty(String.valueOf(CHECKBOX_MESSAGE) + suffix) == null) break;
            if (this.properties.getProperty(String.valueOf(SEPARATOR) + suffix) != null) {
                this.lastButton = i;
                break;
            }
            Button b = this.createCheckBox(c, suffix);
            list.add(b);
            ++i;
        }
        this.buttons = list.toArray(new Button[0]);
        return c;
    }

    private void createSeparator(Composite parent, boolean indent) {
        Label lb = new Label(parent, 258);
        GridData data = new GridData(768);
        if (indent && this.getImage() != null) {
            data.horizontalIndent = this.getImage().getImageData().width + 8;
        }
        lb.setLayoutData((Object)data);
    }

    private void createSpace(Composite parent, int height) {
        Label lb = new Label(parent, 256);
        GridData data = new GridData(768);
        data.heightHint = height;
        lb.setLayoutData((Object)data);
    }

    protected void buttonPressed(int buttonId) {
        this.properties.put(CHECKED, (Object)this.button.getSelection());
        int i = 0;
        while (i < this.buttons.length) {
            this.properties.put(String.valueOf(CHECKED) + "_" + (i + 1), (Object)this.buttons[i].getSelection());
            ++i;
        }
        super.buttonPressed(buttonId);
    }

    protected Control createButtonBar(Composite parent) {
        if (this.lastButton < 0) {
            return super.createButtonBar(parent);
        }
        Composite vcomposite = new Composite(parent, 0);
        GridLayout vl = new GridLayout(1, false);
        vl.marginHeight = 0;
        vl.marginWidth = 0;
        vl.verticalSpacing = 0;
        vcomposite.setLayout((Layout)vl);
        GridData d = new GridData(768);
        d.horizontalSpan = 2;
        vcomposite.setLayoutData((Object)d);
        this.createSeparator(vcomposite, false);
        this.createSpace(vcomposite, 10);
        Composite composite = new Composite(vcomposite, 0);
        GridLayout l = new GridLayout(2, false);
        l.marginHeight = 0;
        l.marginWidth = 0;
        l.verticalSpacing = 0;
        composite.setLayout((Layout)l);
        GridData data = new GridData(772);
        composite.setLayoutData((Object)data);
        Button b = this.createCheckBox(composite, "_" + this.lastButton);
        b.setLayoutData((Object)new GridData());
        Button[] bs = new Button[this.buttons.length + 1];
        System.arraycopy(this.buttons, 0, bs, 0, this.buttons.length);
        bs[this.buttons.length] = b;
        this.buttons = bs;
        Composite w = new Composite(composite, 0);
        GridLayout wl = new GridLayout(2, false);
        wl.marginHeight = 0;
        wl.marginWidth = 0;
        wl.horizontalSpacing = 0;
        wl.verticalSpacing = 0;
        w.setLayout((Layout)wl);
        w.setLayoutData((Object)new GridData(768));
        Control c = super.createButtonBar(w);
        c.setLayoutData((Object)new GridData(896));
        return vcomposite;
    }
}

