/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.hibernate.eclipse.console.model.IRevEngColumn;
import org.hibernate.eclipse.console.model.IRevEngGenerator;
import org.hibernate.eclipse.console.model.IRevEngParameter;
import org.hibernate.eclipse.console.model.IRevEngPrimaryKey;
import org.hibernate.eclipse.console.model.IRevEngTable;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.mapper.MapperMessages;

public class TablePropertiesLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        String internalText = this.getInternalText(element);
        if (internalText == null) {
            return "<n/a>";
        }
        return internalText;
    }

    private String getInternalText(Object element) {
        if (element instanceof IRevEngTable) {
            IRevEngTable table = (IRevEngTable)element;
            return this.getLabel(table);
        }
        if (element instanceof IRevEngColumn) {
            return ((IRevEngColumn)element).getName();
        }
        if (element instanceof IRevEngPrimaryKey) {
            return MapperMessages.TablePropertiesLabelProvider_primary_key;
        }
        if (element instanceof IRevEngGenerator) {
            return ((IRevEngGenerator)element).getGeneratorClassName();
        }
        if (element instanceof IRevEngParameter) {
            IRevEngParameter new_name = (IRevEngParameter)element;
            return new_name.getName();
        }
        return super.getText(element);
    }

    private String getLabel(IRevEngTable table) {
        StringBuffer res = new StringBuffer();
        if (table.getCatalog() != null) {
            res.append(table.getCatalog());
        }
        if (table.getSchema() != null) {
            if (res.length() != 0) {
                res.append(".");
            }
            res.append(table.getSchema());
        }
        if (table.getName() != null) {
            if (res.length() != 0) {
                res.append(".");
            }
            res.append(table.getName());
        }
        return res.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof IRevEngTable) {
            return EclipseImages.getImage((String)"TABLE");
        }
        if (element instanceof IRevEngColumn) {
            return EclipseImages.getImage((String)"COLUMN");
        }
        if (element instanceof IRevEngParameter) {
            return EclipseImages.getImage((String)"PARAMETER");
        }
        if (element instanceof IRevEngPrimaryKey) {
            return EclipseImages.getImage((String)"PRIMARY_KEY");
        }
        if (element instanceof IRevEngGenerator) {
            return EclipseImages.getImage((String)"GENERATOR");
        }
        return null;
    }
}

