/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi.endpoint;

import java.lang.reflect.Method;

import javax.resource.ResourceException;

/**
 * A factory for message end points
 */
public interface MessageEndpoint
{
   /**
	 * Invoked before delivery
	 * 
	 * @param method the method on the endpoint
	 * @throws NoSuchMethodException when there is no such method
	 * @throws ResourceException for a generic error
	 * @throws ApplicationServerInternalException for an error in the
	 *            application server
	 * @throws IllegalStateException when not in the correct state, eg. before
	 *            and after delivery are not paired
    * @throws UnavailableException when the endpoint is unavailable
	 */
   void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException;

   /**
	 * Invoked after delivery
	 * 
	 * @throws ResourceException for a generic error
    * @throws ApplicationServerInternalException for an error in the
    *            application server
    * @throws IllegalStateException when not in the correct state, eg. before
    *            and after delivery are not paired
    * @throws UnavailableException when the endpoint is unavailable
	 */
   void afterDelivery() throws ResourceException;

   /**
    * Release the endpoint
    */
   void release();
}