/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view;

import java.util.Iterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;

public class HibernateUtils {
    public static boolean isPrimaryKey(Column column) {
        Table table = HibernateUtils.getTable(column);
        return table != null && table.getPrimaryKey() != null && table.getPrimaryKey().containsColumn(column);
    }

    public static boolean isForeignKey(Column column) {
        Table table = HibernateUtils.getTable(column);
        if (table != null) {
            Iterator iter = table.getForeignKeyIterator();
            while (iter.hasNext()) {
                ForeignKey fk = (ForeignKey)iter.next();
                if (!fk.containsColumn(column)) continue;
                return true;
            }
        }
        return false;
    }

    public static Table getTable(Column column) {
        if (column.getValue() != null) {
            return column.getValue().getTable();
        }
        return null;
    }
}

