/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.TitleFigure;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.TopLineBorder;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ColorConstants;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmShapeEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeEditPart
extends OrmEditPart
implements NodeEditPart {
    protected ChopboxAnchorNearestSide sourceAnchor = null;
    protected ChopboxAnchorNearestSide targetAnchor = null;

    @Override
    public void setModel(Object model) {
        super.setModel(model);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ShapesSelectionEditPolicy());
    }

    @Override
    protected IFigure createFigure() {
        Label label = new Label();
        FontData[] fontData = Display.getCurrent().getSystemFont().getFontData();
        fontData[0].height = this.getOrmDiagram().getFontHeight();
        label.setFont(ResourceManager.getInstance().getFont(fontData[0]));
        label.setText(this.getOrmDiagram().getLabelProvider().getText(this.getElement()));
        label.setBackgroundColor(this.getColor());
        label.setIcon(this.getOrmDiagram().getLabelProvider().getImage(this.getElement()));
        label.setLabelAlignment(1);
        label.setOpaque(true);
        TopLineBorder border = new TopLineBorder(1, 2 + this.getModelShape().getIndent(), 1, 2);
        OrmShapeEditPart osep = this.getOrmShapeEditPart();
        border.setColor(osep != null ? osep.getColor() : ResourceManager.getInstance().getColor(new RGB(0, 0, 0)));
        label.setBorder((Border)border);
        return label;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("selected".equals(prop)) {
            this.updateSelected((Boolean)evt.getNewValue());
        } else if ("visible".equals(prop)) {
            this.getFigure().setVisible(((Boolean)evt.getNewValue()).booleanValue());
        } else if ("refresh".equals(prop)) {
            this.getFigure().setVisible(this.getModelShape().isVisible());
            this.updateSelected(this.getModelShape().isSelected());
        } else if ("setFocus".equals(prop)) {
            this.getViewer().select((EditPart)this);
            this.getViewer().reveal((EditPart)this);
        }
        this.refresh();
    }

    protected void updateSelected(boolean selected) {
        if (!selected) {
            this.setSelected(0);
        }
        this.getFigure().setBackgroundColor(selected ? this.getSelectionColor() : this.getColor());
        this.getFigure().setForegroundColor(ResourceManager.getInstance().getColor(selected ? new RGB(255, 255, 255) : new RGB(0, 0, 0)));
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            if (this.getModelShape().getOrmElement() instanceof Column) {
                if (this.getModelShape().getTargetConnections().size() > 0) {
                    this.getModelShape().getTargetConnections().get(0).getSource().setFocus();
                }
            } else if (this.getModelShape().getSourceConnections().size() > 0) {
                this.getModelShape().getSourceConnections().get(0).getTarget().setFocus();
            }
        } else {
            super.performRequest(req);
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModelShape().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModelShape().removePropertyChangeListener(this);
        }
    }

    protected Shape getModelShape() {
        return (Shape)this.getModel();
    }

    protected List<Connection> getModelSourceConnections() {
        return this.getModelShape().getSourceConnections();
    }

    protected List<Connection> getModelTargetConnections() {
        return this.getModelShape().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = this.createConnectionAnchor(connection, true);
        } else if (this.sourceAnchor.getConnection() == null) {
            this.sourceAnchor.setConnection(connection);
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (this.targetAnchor == null) {
            this.targetAnchor = this.createConnectionAnchor(connection, false);
        } else if (this.targetAnchor.getConnection() == null) {
            this.targetAnchor.setConnection(connection);
        }
        return this.targetAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = this.createConnectionAnchor(null, true);
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (this.targetAnchor == null) {
            this.targetAnchor = this.createConnectionAnchor(null, false);
        }
        return this.targetAnchor;
    }

    protected ChopboxAnchorNearestSide createConnectionAnchor(ConnectionEditPart connection, boolean flagSource) {
        return new ChopboxAnchorNearestSide(connection, flagSource, this.getFigure());
    }

    protected OrmShapeEditPart getOrmShapeEditPart() {
        ShapeEditPart part;
        int i = 0;
        for (part = this; part != null && !(part instanceof OrmShapeEditPart); part = part.getParent()) {
            if (i++ <= 4) continue;
            throw new RuntimeException();
        }
        return (OrmShapeEditPart)part;
    }

    protected Color getColor() {
        Object el = this.getElement();
        if (el instanceof PersistentClass || el instanceof Component) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(ColorConstants.Colors_PersistentClassR), Integer.parseInt(ColorConstants.Colors_PersistentClassG), Integer.parseInt(ColorConstants.Colors_PersistentClassB)));
        }
        if (el instanceof Property || el instanceof SimpleValue) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(ColorConstants.Colors_PersistentFieldR), Integer.parseInt(ColorConstants.Colors_PersistentFieldG), Integer.parseInt(ColorConstants.Colors_PersistentFieldB)));
        }
        if (el instanceof Column) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(ColorConstants.Colors_DatabaseColumnR), Integer.parseInt(ColorConstants.Colors_DatabaseColumnG), Integer.parseInt(ColorConstants.Colors_DatabaseColumnB)));
        }
        if (el instanceof Table) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(ColorConstants.Colors_DatabaseTableR), Integer.parseInt(ColorConstants.Colors_DatabaseTableG), Integer.parseInt(ColorConstants.Colors_DatabaseTableB)));
        }
        if (el instanceof DependantValue) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(ColorConstants.Colors_DatabaseTableR), Integer.parseInt(ColorConstants.Colors_DatabaseTableG), Integer.parseInt(ColorConstants.Colors_DatabaseTableB)));
        }
        if (el instanceof OneToMany) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(ColorConstants.Colors_PersistentFieldR), Integer.parseInt(ColorConstants.Colors_PersistentFieldG), Integer.parseInt(ColorConstants.Colors_PersistentFieldB)));
        }
        return ResourceManager.getInstance().getColor(new RGB(255, 0, 0));
    }

    protected Color getSelectionColor() {
        Object el = this.getElement();
        if (el instanceof PersistentClass || el instanceof Property || el instanceof SimpleValue || el instanceof OneToMany) {
            return ResourceManager.getInstance().getColor(new RGB(112, 161, 99));
        }
        if (el instanceof Table || el instanceof Column) {
            return ResourceManager.getInstance().getColor(new RGB(66, 173, 247));
        }
        return ResourceManager.getInstance().getColor(new RGB(255, 0, 0));
    }

    protected Object getElement() {
        return this.getModelShape().getOrmElement();
    }

    public class ChopboxAnchorNearestSide
    extends ChopboxAnchor {
        protected ConnectionEditPart base;
        protected boolean flagSource;

        public ChopboxAnchorNearestSide(ConnectionEditPart base, boolean flagSource, IFigure owner) {
            super(owner);
            this.base = base;
            this.flagSource = flagSource;
        }

        public IFigure getOwner() {
            IFigure ownerFigure = super.getOwner();
            if (ownerFigure instanceof TitleFigure && ownerFigure.getChildren().size() > 0) {
                ownerFigure = (IFigure)ownerFigure.getChildren().get(0);
            }
            return ownerFigure;
        }

        public Point getLocation(Point reference) {
            Rectangle r = Rectangle.SINGLETON;
            IFigure ownerFigure = this.getOwner();
            r.setBounds(ownerFigure.getBounds());
            ownerFigure.translateToAbsolute((Translatable)r);
            Point result = r.getCenter();
            boolean bPreferLeft = reference.x < result.x;
            result.x = bPreferLeft ? r.x : r.x + r.width;
            return result;
        }

        public ConnectionEditPart getConnection() {
            return this.base;
        }

        public void setConnection(ConnectionEditPart connection) {
            this.base = connection;
        }
    }

    private class ShapesSelectionEditPolicy
    extends SelectionEditPolicy {
        private ShapesSelectionEditPolicy() {
        }

        protected void hideSelection() {
            ShapeEditPart.this.getModelShape().setSelected(false);
            for (Connection element : ShapeEditPart.this.getModelShape().getSourceConnections()) {
                element.setSelected(false);
            }
            for (Connection element : ShapeEditPart.this.getModelShape().getTargetConnections()) {
                element.setSelected(false);
            }
        }

        protected void showSelection() {
            ShapeEditPart.this.getModelShape().setSelected(true);
            for (Connection element : ShapeEditPart.this.getModelShape().getSourceConnections()) {
                element.setSelected(true);
            }
            for (Connection element : ShapeEditPart.this.getModelShape().getTargetConnections()) {
                element.setSelected(true);
            }
        }
    }
}

