/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.data.DiagramInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.AutoLayoutImpl;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ShapesXYLayoutEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditPart
extends OrmEditPart {
    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ShapesXYLayoutEditPolicy((XYLayout)this.getContentPane().getLayoutManager()));
    }

    @Override
    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        if (this.isManhattanConnectionRouter()) {
            this.getOrmDiagram().setupFanConnectionRouter();
            this.setupManhattanConnectionRouter();
        } else {
            this.getOrmDiagram().setupManhattanConnectionRouter();
            this.setupFanConnectionRouter();
        }
        return f;
    }

    public void setupManhattanConnectionRouter() {
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        this.getOrmDiagram().setupManhattanConnectionRouter();
    }

    public void setupFanConnectionRouter() {
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new FanRouter());
        this.getOrmDiagram().setupFanConnectionRouter();
    }

    public boolean isManhattanConnectionRouter() {
        return this.getOrmDiagram().isManhattanConnectionRouter();
    }

    public boolean isFanConnectionRouter() {
        return this.getOrmDiagram().isFanConnectionRouter();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("autolayout".equals(prop)) {
            this.refresh();
            this.autolayout();
        } else if ("refresh".equals(prop)) {
            this.refresh();
        } else if ("dirty".equals(prop)) {
            ((DiagramViewer)((DefaultEditDomain)this.getViewer().getEditDomain()).getEditorPart()).refreshDirty();
        }
        this.refresh();
    }

    public void refresh() {
        IFigure layer = this.getLayer("Primary Layer");
        this.getOrmDiagram().updateWidthAndHeight(layer.getBounds().width, layer.getBounds().height);
        double zoom = ((DiagramViewer)((DefaultEditDomain)this.getViewer().getEditDomain()).getEditorPart()).getZoom();
        this.getOrmDiagram().setZoom(zoom);
        super.refresh();
    }

    protected List<Shape> getModelChildren() {
        ArrayList<Shape> res = new ArrayList<Shape>();
        Iterator<Shape> it = this.getOrmDiagram().getChildrenIterator();
        while (it.hasNext()) {
            res.add(it.next());
        }
        return res;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((BaseElement)this.getModel()).addPropertyChangeListener(this);
            if (!this.getOrmDiagram().isFileLoadSuccessfull()) {
                this.refresh();
                this.autolayout();
                this.refresh();
                this.getOrmDiagram().setDirty(false);
            }
        }
    }

    public void autolayout() {
        DiagramInfo process = new DiagramInfo(this.getViewer(), this.getOrmDiagram());
        AutoLayoutImpl layout = new AutoLayoutImpl();
        layout.setGridStep(5);
        layout.setOverride(true);
        layout.setProcess(process);
    }

    public void setToFront(EditPart ep) {
        int index = this.getChildren().indexOf(ep);
        if (index == -1) {
            return;
        }
        if (index != this.getChildren().size() - 1) {
            this.reorderChild(ep, this.getChildren().size() - 1);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((BaseElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    public IFigure getLayer(Object layer) {
        return super.getLayer(layer);
    }
}

