/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleShapeVisibleStateCommand
extends Command {
    protected OrmShape primalElement;
    protected List<OrmShape> selectedShape;
    protected List<Boolean> selectedShapeStates;

    public ToggleShapeVisibleStateCommand(List<OrmShape> selectedShape, OrmShape primalElement) {
        this.primalElement = primalElement;
        this.selectedShape = selectedShape;
        this.selectedShapeStates = new ArrayList<Boolean>();
        for (OrmShape shape : selectedShape) {
            this.selectedShapeStates.add(shape.isVisible());
        }
    }

    public void execute() {
        boolean visState = false;
        if (this.primalElement != null) {
            visState = this.primalElement.isVisible();
        } else if (this.selectedShape.size() > 0) {
            visState = this.selectedShape.get(0).isVisible();
        }
        for (OrmShape shape : this.selectedShape) {
            Object ormElement = shape.getOrmElement();
            if (!(ormElement instanceof PersistentClass) && !(ormElement instanceof Table)) continue;
            shape.setVisible(!visState);
        }
    }

    public void undo() {
        int i = 0;
        while (i < this.selectedShape.size()) {
            OrmShape shape = this.selectedShape.get(i);
            Object ormElement = shape.getOrmElement();
            if (ormElement instanceof PersistentClass || ormElement instanceof Table) {
                shape.setVisible(this.selectedShapeStates.get(i));
            }
            ++i;
        }
    }

    public boolean canUndo() {
        return this.selectedShape != null;
    }
}

