/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleShapeExpandStateCommand
extends Command {
    protected ExpandableShape primalElement;
    protected List<ExpandableShape> selectedShape;
    protected List<Boolean> selectedShapeStates;

    public ToggleShapeExpandStateCommand(List<ExpandableShape> selectedShape, ExpandableShape primalElement) {
        this.primalElement = primalElement;
        this.selectedShape = selectedShape;
        this.selectedShapeStates = new ArrayList<Boolean>();
        for (ExpandableShape shape : selectedShape) {
            this.selectedShapeStates.add(shape.isExpanded());
        }
    }

    public void execute() {
        boolean expState = false;
        if (this.primalElement != null) {
            expState = this.primalElement.isExpanded();
        } else if (this.selectedShape.size() > 0) {
            expState = this.selectedShape.get(0).isExpanded();
        }
        for (ExpandableShape shape : this.selectedShape) {
            shape.setExpanded(!expState);
        }
    }

    public void undo() {
        int i = 0;
        while (i < this.selectedShape.size()) {
            ExpandableShape shape = this.selectedShape.get(i);
            shape.setExpanded(this.selectedShapeStates.get(i));
            ++i;
        }
    }

    public boolean canUndo() {
        return this.selectedShape != null;
    }
}

