/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.build;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;

public class SaveArchivesJob
extends Job {
    private Runnable runnable;
    private IPath projectPath;

    public SaveArchivesJob(IPath projectPath) {
        this(projectPath, null, null);
    }

    public SaveArchivesJob(IPath projectPath, Runnable runnable, String jobName) {
        super(jobName == null ? ArchivesCoreMessages.SaveArchivesJob : jobName);
        this.runnable = runnable;
        this.projectPath = projectPath;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.runnable != null) {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCoreMessages.ErrorPreSave, (Throwable)e);
                return status;
            }
        }
        try {
            ArchivesModel.instance().getRoot(this.projectPath).save((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ArchivesModelException ame) {
            Status status = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCoreMessages.ErrorUpdatingModel, (Throwable)ame);
            return status;
        }
        return Status.OK_STATUS;
    }
}

