/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.views.contentoutline;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeAdapter;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeAdapterFactory;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JFaceNodeAdapterForXML
extends JFaceNodeAdapter {
    static final Class ADAPTER_KEY = IJFaceNodeAdapter.class;
    protected INodeAdapterFactory adapterFactory;
    static Map nameToMap = new HashMap();

    static {
        nameToMap.put("many-to-one", "MANYTOONE");
        nameToMap.put("one-to-many", "ONETOMANY");
        nameToMap.put("property", "PROPERTY");
        nameToMap.put("class", "MAPPEDCLASS");
        nameToMap.put("subclass", "MAPPEDCLASS");
        nameToMap.put("joined-subclass", "MAPPEDCLASS");
        nameToMap.put("union-subclass", "MAPPEDCLASS");
        nameToMap.put("id", "IDPROPERTY");
        nameToMap.put("one-to-one", "ONETOONE");
        nameToMap.put("component", "ONETOONE");
    }

    public JFaceNodeAdapterForXML(JFaceNodeAdapterFactory adapterFactory) {
        super(adapterFactory);
        this.adapterFactory = adapterFactory;
    }

    public String getLabelText(Object object) {
        Node firstAttribute;
        String result = this.getNodeName(object);
        Node node = (Node)object;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (firstAttribute = attributes.item(0)) != null) {
            return String.valueOf(result) + " " + firstAttribute.getNodeName() + "=\"" + firstAttribute.getNodeValue() + "\"";
        }
        return result;
    }

    private String getNodeName(Object object) {
        Node node = (Node)object;
        String nodeName = node.getNodeName();
        if (node.getNodeType() == 7 && "xml".equals(nodeName)) {
            return MapperMessages.xml_hibernate_tools;
        }
        return nodeName;
    }

    public Object getParent(Object object) {
        Node node = (Node)object;
        return node.getParentNode();
    }

    public boolean hasChildren(Object object) {
        return super.hasChildren(object);
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(ADAPTER_KEY);
    }

    protected Image createImage(Object object) {
        String key;
        Node node = (Node)object;
        if (node.getNodeType() == 1 && (key = (String)nameToMap.get(this.getNodeName(node))) != null) {
            return EclipseImages.getImage((String)key);
        }
        return super.createImage(object);
    }
}

