/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.launch.core.refactoring.Messages;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectDefaultConfigurationChange
extends Change {
    private IProject project;
    private String newConsoleName;

    public ProjectDefaultConfigurationChange(IProject project, String newCCName) {
        this.project = project;
        this.newConsoleName = newCCName;
    }

    public String getName() {
        return String.valueOf(Messages.ProjectDefaultConfigurationChange_name) + this.project.getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            ProjectScope scope = new ProjectScope(this.project);
            IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
            String oldName = node.get("default.configuration", null);
            node.putBoolean("hibernate3.enabled", true);
            node.put("default.configuration", this.newConsoleName);
            node.flush();
            return new ProjectDefaultConfigurationChange(this.project, oldName);
        }
        catch (BackingStoreException e) {
            HibernateConsolePlugin.openError(new Shell(), Messages.ProjectDefaultConfigurationChange_error_title, e.getLocalizedMessage(), e, 1);
            return new NullChange();
        }
    }

    public Object getModifiedElement() {
        return this.project;
    }
}

