/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.graph.AbstractGraphViewPart;

public class ToggleLayoutAction
extends Action {
    final AbstractGraphViewPart view;
    private final String pluginKey;

    public ToggleLayoutAction(AbstractGraphViewPart view, String pluginKey) {
        super(HibernateConsoleMessages.ToggleLayoutAction_auto_layout, 2);
        this.view = view;
        this.pluginKey = pluginKey;
        this.setImageDescriptor(EclipseImages.getImageDescriptor("LAYOUT"));
        this.setDisabledImageDescriptor(EclipseImages.getImageDescriptor("LAYOUT"));
        Preferences prefs = HibernateConsolePlugin.getDefault().getPluginPreferences();
        boolean checked = prefs.getBoolean(pluginKey);
        this.valueChanged(!checked, false);
    }

    public void run() {
        this.valueChanged(!this.isChecked(), true);
    }

    private void valueChanged(boolean value, boolean doStore) {
        this.setChecked(!value);
        this.view.setManualLayout(value);
        this.setToolTipText(value ? HibernateConsoleMessages.ToggleLayoutAction_manual_layout_active : HibernateConsoleMessages.ToggleLayoutAction_auto_layout_active);
        this.setDescription(value ? HibernateConsoleMessages.ToggleLayoutAction_enable_auto_layout : HibernateConsoleMessages.ToggleLayoutAction_enable_manual_layout);
        if (doStore) {
            Preferences prefs = HibernateConsolePlugin.getDefault().getPluginPreferences();
            prefs.setValue(this.pluginKey, value);
            HibernateConsolePlugin.getDefault().savePluginPreferences();
        }
    }
}

