/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.hibernate.console.QueryPage;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.views.QueryPageTabView;

public class QueryPageViewer {
    public static final Object NULL_VALUE = new Object(){

        public String toString() {
            return "<null>";
        }
    };
    private final QueryPage queryPage;
    private TableViewer tableViewer;
    private CTabItem tabItem;
    private final QueryPageTabView qrView;
    protected PropertyChangeListener queryPagePropChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("tabName".equals(event.getPropertyName())) {
                QueryPageViewer.this.tabItem.setText(QueryPageViewer.this.queryPage.getTabName());
            }
        }
    };

    public QueryPageViewer(QueryPageTabView qrView, QueryPage queryPage) {
        this.qrView = qrView;
        this.queryPage = queryPage;
        this.createControl();
    }

    protected CTabItem getTabItem() {
        return this.tabItem;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    protected void createControl() {
        this.tabItem = new CTabItem(this.qrView.tabs, 0);
        this.tabItem.setData((Object)this.queryPage);
        int index = this.qrView.tabs.getItems().length;
        Composite composite = new Composite((Composite)this.qrView.tabs, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.tabItem.setText(this.queryPage.getTabName());
        this.tabItem.setToolTipText(this.queryPage.getQueryString());
        this.createTable(composite);
        this.tabItem.setControl((Control)composite);
        this.initializePopUpMenu();
        this.qrView.tabs.setSelection(index - 1);
        this.queryPage.addPropertyChangeListener(this.queryPagePropChangeListener);
    }

    private void createTable(Composite composite) {
        Table table = new Table(composite, 67586);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(1808));
        this.addColumnsToTable(table);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.tableViewer.setInput((Object)this.queryPage);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                QueryPageViewer.this.tableDoubleClicked();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QueryPageViewer.this.tableDoubleClicked();
            }
        });
        this.packColumns(table);
    }

    private void tableDoubleClicked() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.qrView.fireSelectionChangedEvent(selection);
        }
    }

    private void packColumns(Table table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    private int addColumnsToTable(Table table) {
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        List columns = this.queryPage.getPathNames();
        int columnCount = columns.size();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(((String)columns.get(i)).toString());
            ++i;
        }
        return columnCount;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("rows".equals(event.getPropertyName())) {
            this.tableViewer.refresh();
        } else if ("columns".equals(event.getPropertyName())) {
            Table table = this.tableViewer.getTable();
            TableColumn[] columns = table.getColumns();
            int i = 0;
            int length = columns == null ? 0 : columns.length;
            while (i < length) {
                columns[i].dispose();
                ++i;
            }
            this.addColumnsToTable(table);
            this.tableViewer.setInput((Object)this.queryPage);
            this.packColumns(table);
            table.layout();
        }
    }

    public void dispose() {
        this.queryPage.removePropertyChangeListener(this.queryPagePropChangeListener);
        this.tabItem.dispose();
    }

    protected QueryPage getQueryPage() {
        return this.queryPage;
    }

    private void initializePopUpMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
            }
        });
        Menu contextMenu = manager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(contextMenu);
    }

    protected ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    static class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof QueryPage) {
                QueryPage qp = (QueryPage)inputElement;
                Object[] objects = qp.getList().toArray();
                if (qp.getExceptions().isEmpty()) {
                    return this.ensureNotNull(objects);
                }
                Object[] throwables = qp.getExceptions().toArray(new Throwable[0]);
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.QueryPageViewer_exception_while_executing_hql_query, (Throwable[])throwables);
                return throwables;
            }
            return null;
        }

        private Object[] ensureNotNull(Object[] objects) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] == null) {
                    objects[i] = NULL_VALUE;
                }
                ++i;
            }
            return objects;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class LabelProviderImpl
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object value;
            block8: {
                block7: {
                    try {
                        value = element;
                        if (element instanceof QueryPage) {
                            value = ((QueryPage)element).getList().get(columnIndex);
                        }
                        if (value != null) break block7;
                        return "";
                    }
                    catch (RuntimeException e) {
                        String out = NLS.bind((String)HibernateConsoleMessages.QueryPageViewer_error, (Object)e.getMessage());
                        return out;
                    }
                }
                if (value.getClass().isArray()) {
                    Object[] arr = (Object[])value;
                    if (columnIndex > arr.length - 1) {
                        return HibernateConsoleMessages.QueryPageViewer_unknown_value;
                    }
                    return "" + arr[columnIndex];
                }
                if (columnIndex == 0) break block8;
                return "?";
            }
            return value.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

