/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.ext;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.eclipse.console.ext.ConsoleExtension;

public class ConsoleExtensionDefinition {
    public static final String CLASSNAME = "classname";
    public static final String HIBERNATE_VERSION = "version";
    private final String hibernateVersion;
    private IConfigurationElement element;

    public ConsoleExtensionDefinition(IConfigurationElement element) {
        this(element.getAttribute(CLASSNAME), element.getAttribute(HIBERNATE_VERSION));
        this.element = element;
    }

    private ConsoleExtensionDefinition(String classname, String hibernateVersion) {
        this.hibernateVersion = hibernateVersion;
    }

    public ConsoleExtension createConsoleExtensionInstance(HibernateExtension hibernateExtension) {
        if (hibernateExtension != null) {
            try {
                ConsoleExtension consoleExtension = (ConsoleExtension)this.element.createExecutableExtension(CLASSNAME);
                consoleExtension.setHibernateException(hibernateExtension);
                return consoleExtension;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getHibernateVersion() {
        return this.hibernateVersion;
    }
}

