/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.io.FileNotFoundException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class OpenSourceAction
extends SelectionListenerAction {
    public static final String OPENSOURCE_ACTIONID = "actionid.opensource";
    private String imageFilePath = "icons/images/java.gif";

    public OpenSourceAction() {
        super(HibernateConsoleMessages.OpenSourceAction_open_source_file);
        this.setToolTipText(HibernateConsoleMessages.OpenSourceAction_open_source_file);
        this.setEnabled(true);
        this.setImageDescriptor(HibernateConsolePlugin.getImageDescriptor(this.imageFilePath));
        this.setId(OPENSOURCE_ACTIONID);
    }

    public void run() {
        IStructuredSelection sel = this.getStructuredSelection();
        if (!(sel instanceof TreeSelection)) {
            return;
        }
        TreePath[] paths = ((TreeSelection)sel).getPaths();
        int i = 0;
        while (i < paths.length) {
            Object prevSegment;
            TreePath path = paths[i];
            Object lastSegment = path.getLastSegment();
            PersistentClass persClass = this.getPersistentClass(lastSegment);
            ConsoleConfiguration consoleConfig = (ConsoleConfiguration)path.getSegment(0);
            String fullyQualifiedName = null;
            if (lastSegment instanceof Property && (prevSegment = path.getParentPath().getLastSegment()) instanceof Property && ((Property)prevSegment).isComposite()) {
                fullyQualifiedName = ((Component)((Property)prevSegment).getValue()).getComponentClassName();
            }
            if (fullyQualifiedName == null && persClass != null) {
                fullyQualifiedName = persClass.getClassName();
            }
            try {
                OpenSourceAction.run(consoleConfig, lastSegment, fullyQualifiedName);
            }
            catch (JavaModelException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenSourceAction_cannot_find_source_file, e);
            }
            catch (PartInitException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenSourceAction_cannot_open_source_file, e);
            }
            catch (FileNotFoundException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenSourceAction_cannot_find_source_file, e);
            }
            ++i;
        }
    }

    public static IEditorPart run(ConsoleConfiguration consoleConfig, Object selection, String fullyQualifiedName) throws JavaModelException, PartInitException, FileNotFoundException {
        IEditorPart editorPart;
        if (fullyQualifiedName == null) {
            return null;
        }
        IJavaProject[] projs = ProjectUtils.findJavaProjects(consoleConfig);
        String remainder = null;
        IType type = null;
        IJavaProject proj = null;
        if (fullyQualifiedName.indexOf("$") > 0) {
            remainder = fullyQualifiedName.substring(fullyQualifiedName.indexOf("$") + 1);
            fullyQualifiedName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf("$"));
            int i = 0;
            while (i < projs.length && type == null) {
                proj = projs[i];
                type = ProjectUtils.findType(proj, fullyQualifiedName);
                ++i;
            }
            while (remainder.indexOf("$") > 0) {
                String subtype = remainder.substring(0, fullyQualifiedName.indexOf("$"));
                type = type.getType(subtype);
                remainder = remainder.substring(fullyQualifiedName.indexOf("$") + 1);
            }
            type = type.getType(remainder);
        } else {
            int i = 0;
            while (i < projs.length && type == null) {
                proj = projs[i];
                type = ProjectUtils.findType(proj, fullyQualifiedName);
                ++i;
            }
        }
        IType jElement = null;
        if (selection instanceof Property) {
            String parentClassName;
            String selectionName = ((Property)selection).getName();
            IType typeSave = type;
            while (!((jElement = type.getField(selectionName)) != null && jElement.exists() || (parentClassName = ProjectUtils.getParentTypename(proj, type.getFullyQualifiedName())) == null)) {
                type = ProjectUtils.findType(proj, parentClassName);
                int i = 0;
                while (i < projs.length && type == null) {
                    proj = projs[i];
                    type = ProjectUtils.findType(proj, fullyQualifiedName);
                    ++i;
                }
                if (type != null) continue;
            }
            if (jElement == null || !jElement.exists()) {
                type = typeSave;
            }
        }
        if (jElement == null) {
            jElement = type;
        }
        if ((editorPart = JavaUI.openInEditor(type)) instanceof JavaEditor) {
            JavaEditor jEditor = (JavaEditor)editorPart;
            OpenSourceAction.selectionToEditor((IJavaElement)jElement, jEditor);
        }
        if (editorPart == null) {
            String out = NLS.bind((String)HibernateConsoleMessages.OpenSourceAction_source_file_for_class_not_found, (Object)fullyQualifiedName);
            throw new FileNotFoundException(out);
        }
        return editorPart;
    }

    private PersistentClass getPersistentClass(Object selection) {
        if (selection instanceof Property) {
            return ((Property)selection).getPersistentClass();
        }
        if (selection instanceof PersistentClass) {
            return (PersistentClass)selection;
        }
        return null;
    }

    private static void selectionToEditor(IJavaElement jElement, JavaEditor jEditor) {
        if (jEditor != null) {
            jEditor.setSelection(jElement);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return super.getImageDescriptor();
    }
}

