/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.PluginAction;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.tool.hbm2x.XMLPrettyPrinter;

public class JTidyFormatAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        IStructuredSelection selection = (IStructuredSelection)((PluginAction)action).getSelection();
        String out = NLS.bind((String)HibernateConsoleMessages.JTidyFormatAction_do_you_want_format_xml_files_with_jtidy, (Object)selection.size());
        if (selection != null && MessageDialog.openQuestion((Shell)this.targetPart.getSite().getShell(), (String)HibernateConsoleMessages.JTidyFormatAction_format_with_jtidy, (String)out)) {
            Iterator iterator = selection.iterator();
            try {
                while (iterator.hasNext()) {
                    IFile file = (IFile)iterator.next();
                    InputStream contents = null;
                    ByteArrayOutputStream bos = null;
                    ByteArrayInputStream stream = null;
                    try {
                        contents = file.getContents();
                        bos = new ByteArrayOutputStream();
                        XMLPrettyPrinter.prettyPrint((InputStream)contents, (OutputStream)bos);
                        stream = new ByteArrayInputStream(bos.toByteArray());
                        file.setContents((InputStream)stream, true, true, null);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                        if (bos != null) {
                            bos.close();
                        }
                        if (contents != null) {
                            contents.close();
                        }
                    }
                }
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().showError(this.targetPart.getSite().getShell(), HibernateConsoleMessages.JTidyFormatAction_error_while_running_jtidy, e);
            }
            catch (IOException io) {
                HibernateConsolePlugin.getDefault().showError(this.targetPart.getSite().getShell(), HibernateConsoleMessages.JTidyFormatAction_error_while_running_jtidy, io);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

