/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor.bundlemodel;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.propertieseditor.bundlemodel.BundleModel;

public class PropertyModel {
    Map<String, String> values = new HashMap<String, String>();
    XModelObject object;
    BundleModel bundleModel;

    public PropertyModel(BundleModel bundleModel) {
        this.bundleModel = bundleModel;
    }

    public void setModelObject(XModelObject object) {
        this.object = object;
        object.setObject("propertyModel", (Object)this);
    }

    public XModelObject getModelObject() {
        return this.object;
    }

    public String getName() {
        return this.object.getAttributeValue("name");
    }

    public boolean hasValue(String locale) {
        return this.values.get(locale) != null;
    }

    public String getValue(String locale) {
        String v = this.values.get(locale);
        if (v == null) {
            v = this.values.get("");
        }
        return v == null ? "" : v.toString();
    }

    public void setValue(String locale, String value) {
        if (value == null) {
            if (locale.length() == 0) {
                this.values.clear();
            } else {
                this.values.remove(locale);
            }
        } else {
            this.values.put(locale, value);
        }
    }

    public void setLocale(String locale) {
        this.object.setAttributeValue("value", this.getValue(locale));
    }

    public void commit() {
        String locale = this.bundleModel.getCurrentLocale();
        String v = this.getValue(locale);
        this.setValue(locale, this.object.getAttributeValue("value"));
        if (!v.equals(this.getValue(locale))) {
            this.bundleModel.setModified(true);
        }
    }
}

