/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizard.newfile;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.files.handlers.CreateFileSupport;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.ui.wizard.newfile.NewFileContext;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public abstract class NewFileContextEx
extends NewFileContext {
    protected SpecialWizardSupport createSupport() {
        CreateFileSupport support = new CreateFileSupport();
        return support;
    }

    protected String getActionPath() {
        return null;
    }

    public void setSelection(IStructuredSelection selection) {
        this.errorMesage = null;
        this.resource = null;
        this.folder = null;
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IResource) {
            this.resource = (IResource)o;
        } else if (o instanceof IAdaptable) {
            this.resource = (IResource)((IAdaptable)o).getAdapter(IResource.class);
        }
        if (this.resource != null && !this.resource.getProject().isOpen()) {
            this.errorMesage = "Project is closed";
            return;
        }
        this.folder = EclipseResourceUtil.getObjectByResource((IResource)this.resource);
        if (this.folder == null) {
            this.folder = EclipseResourceUtil.createObjectForResource((IResource)this.resource);
        }
        if (this.folder != null) {
            XModel model = this.folder.getModel();
            if (this.folder.getFileType() <= 1) {
                if (this.folder.getFileType() == 0) {
                    if (this.folder == FileSystemsHelper.getFileSystems((XModel)model) && this.resource != null && this.resource == this.resource.getProject()) {
                        this.folder = EclipseResourceUtil.findFileSystem((IResource)this.resource, (XModel)this.folder.getModel());
                        if (this.folder == null) {
                            this.folder = this.getDefaultFolder(model);
                        }
                    } else {
                        this.folder = FileSystemsHelper.getWebInf((XModel)model);
                    }
                } else if (this.folder.getFileType() == 1) {
                    this.folder = this.folder.getParent();
                }
            }
        }
        if (!(this.folder instanceof FolderImpl)) {
            this.folder = null;
        }
        if (this.folder == null) {
            this.errorMesage = "Cannot find resource " + this.resource.getLocation().toString();
        } else {
            this.support.setActionData(this.action, this.action.getEntityData(this.folder), this.folder, null);
        }
    }

    protected XModelObject getDefaultFolder(XModel model) {
        return FileSystemsHelper.getWebInf((XModel)model);
    }
}

