/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets.xpl;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class SelectableControl
extends Canvas {
    private boolean hasFocus;

    public SelectableControl(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SelectableControl.this.paint(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SelectableControl.this.notifyListeners(13);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    SelectableControl.this.notifyListeners(13);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail != 4) {
                    e.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!SelectableControl.this.hasFocus) {
                    SelectableControl.this.hasFocus = true;
                    SelectableControl.this.redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                if (SelectableControl.this.hasFocus) {
                    SelectableControl.this.hasFocus = false;
                    SelectableControl.this.redraw();
                }
            }
        });
    }

    protected void paint(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.getSize();
        gc.setFont(this.getFont());
        this.paint(gc);
        if (this.hasFocus) {
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    protected abstract void paint(GC var1);

    private void notifyListeners(int eventType) {
        Event event = new Event();
        event.type = eventType;
        event.widget = this;
        this.notifyListeners(eventType, event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)listener);
    }
}

