/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets.xpl;

import java.text.BreakIterator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class FormLabel
extends Label {
    private String text = "";
    int marginWidth = 1;
    int marginHeight = 1;
    private boolean underlined;

    public FormLabel(Composite parent, int style) {
        super(parent, style);
        this.createPaintListener();
        this.initAccessible();
    }

    void createPaintListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FormLabel.this.paint(e);
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null ? text : "";
    }

    protected void checkSubclass() {
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = FormLabel.this.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = FormLabel.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = FormLabel.this.toControl(new Point(e.x, e.y));
                e.childID = FormLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FormLabel.this.getBounds();
                Point pt = FormLabel.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= this.marginWidth * 2;
        }
        Point textSize = this.computeTextSize(innerWidth, hHint);
        int textWidth = textSize.x + 2 * this.marginWidth;
        int textHeight = textSize.y + 2 * this.marginHeight;
        return new Point(textWidth, textHeight);
    }

    public static int computeWrapHeight(GC gc, String text, int width) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int saved = 0;
        int last = 0;
        int height = lineHeight;
        int loc = wb.first();
        while (loc != -1) {
            String word = text.substring(saved, loc);
            Point extent = gc.textExtent(word);
            if (extent.x > width) {
                saved = last;
                height += extent.y;
            }
            last = loc;
            loc = wb.next();
        }
        return height;
    }

    private Point computeTextSize(int wHint, int hHint) {
        Point extent;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && wHint != -1) {
            int height = FormLabel.computeWrapHeight(gc, this.text, wHint);
            extent = new Point(wHint, height);
        } else {
            extent = gc.textExtent(this.getText());
        }
        gc.dispose();
        return extent;
    }

    public static void paintWrapText(GC gc, Point size, String text, int marginWidth, int marginHeight) {
        FormLabel.paintWrapText(gc, size, text, marginWidth, marginHeight, false);
    }

    public static void paintWrapText(GC gc, Point size, String text, int marginWidth, int marginHeight, boolean underline) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int descent = fm.getDescent();
        int saved = 0;
        int last = 0;
        int y = marginHeight;
        int width = size.x - marginWidth * 2;
        int loc = wb.first();
        while (loc != -1) {
            String line = text.substring(saved, loc);
            Point extent = gc.textExtent(line);
            if (extent.x > width) {
                String prevLine = text.substring(saved, last);
                gc.drawString(prevLine, marginWidth, y, true);
                if (underline) {
                    Point prevExtent = gc.textExtent(prevLine);
                    int lineY = y + lineHeight - descent + 1;
                    gc.drawLine(marginWidth, lineY, prevExtent.x, lineY);
                }
                saved = last;
                y += lineHeight;
            }
            last = loc;
            loc = wb.next();
        }
        String lastLine = text.substring(saved, last);
        gc.drawString(lastLine, marginWidth, y, true);
        if (underline) {
            int lineY = y + lineHeight - descent + 1;
            Point lastExtent = gc.textExtent(lastLine);
            gc.drawLine(marginWidth, lineY, marginWidth + lastExtent.x, lineY);
        }
    }

    protected void paint(PaintEvent e) {
        Point s = this.getSize();
        e.gc.setFont(this.getFont());
        e.gc.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            FormLabel.paintWrapText(e.gc, s, this.text, this.marginWidth, this.marginHeight, this.underlined);
        } else {
            e.gc.drawText(this.getText(), this.marginWidth, this.marginHeight, true);
            if (this.underlined) {
                this.underline(e.gc, s);
            }
        }
    }

    private void underline(GC gc, Point s) {
        FontMetrics fm = gc.getFontMetrics();
        int descent = fm.getDescent();
        int lineY = s.y - this.marginHeight - descent + 1;
        gc.drawLine(this.marginWidth, lineY, s.x - this.marginWidth, lineY);
    }
}

