/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets.border;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.model.ui.Insets;
import org.jboss.tools.common.model.ui.widgets.border.Border;

public class FormControlBorder
extends Border {
    private Color inner;
    private Color outer;
    private Insets insets;

    public FormControlBorder(Insets insets) {
        this.insets = insets;
    }

    public FormControlBorder(Color outer, Color inner, Insets insets) {
        this.inner = inner;
        this.outer = outer;
        this.insets = insets;
    }

    public FormControlBorder(Color outer, Color inner) {
        this.inner = inner;
        this.outer = outer;
        this.insets = new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets() {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Composite composite, GC gc) {
        Rectangle r = composite.getClientArea();
        if (this.outer != null) {
            gc.setForeground(this.outer);
        }
        gc.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        if (this.inner != null) {
            gc.setForeground(this.inner);
        }
        gc.drawRectangle(r.x + 1, r.y + 1, r.width - 3, r.height - 3);
    }
}

