/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette.editor;

import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.ui.views.palette.editor.PaletteDialog;
import org.jboss.tools.common.model.ui.wizards.one.ServiceDialogImpl;
import org.jboss.tools.common.model.undo.XUndoManager;

public class PaletteEditor {
    private Shell shell;
    private PaletteDialog dialog;

    public void setObject(Shell shell) {
        this.shell = shell;
    }

    public int execute() {
        XModel model;
        if (this.dialog == null) {
            this.dialog = new PaletteDialog(this.shell);
        }
        if ((model = ModelUtilities.getPreferenceModel()).getService() == null) {
            model.setService((ServiceDialog)new ServiceDialogImpl());
        }
        this.fireTransactionEvent("transaction_begin");
        try {
            XUndoManager undo = model.getUndoManager();
            undo.beginTransaction();
            int code = this.dialog.open();
            if (code == 0) {
                undo.commitTransaction();
                model.saveOptions();
            } else {
                undo.rollbackTransaction();
            }
            int n = code;
            return n;
        }
        finally {
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.dialog = null;
            this.fireTransactionEvent("transaction_end");
        }
    }

    private void fireTransactionEvent(String kind) {
        XModelImpl m = (XModelImpl)ModelUtilities.getPreferenceModel();
        m.fireStructureChanged(m.getByPath("%Palette%"), 2, (Object)kind);
    }
}

