/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.configuration;

import java.util.Collection;
import java.util.HashMap;
import org.jboss.tools.common.model.ui.templates.configuration.IMetaConfigurationSave;
import org.jboss.tools.common.model.ui.templates.model.MetaClassTemplate;
import org.jboss.tools.common.model.ui.templates.model.MetaElementFactory;
import org.jboss.tools.common.model.ui.templates.model.MetaGroup;

public class MetaConfiguration {
    MetaConfiguration parent;
    private HashMap<String, MetaGroup> groups = new HashMap();
    IMetaConfigurationSave saveAgent;

    public void setParent(MetaConfiguration parent) {
        this.parent = parent;
        if (parent != null) {
            for (MetaGroup p : parent.getMetaTemplateGroups()) {
                MetaGroup g = MetaElementFactory.instance.createGroup(p);
                this.groups.put(g.getUri(), g);
            }
        }
    }

    public MetaConfiguration getParent() {
        return this.parent;
    }

    public void setSaveAgent(IMetaConfigurationSave saveAgent) {
        this.saveAgent = saveAgent;
    }

    public void save() {
        if (this.saveAgent != null) {
            this.saveAgent.save();
        }
    }

    public Collection getMetaTemplateGroups() {
        return this.groups.values();
    }

    public MetaGroup getMetaTemplateGroup(String publicId) {
        return this.groups.get(publicId);
    }

    public MetaClassTemplate getMetaTemplate(String publicId, String axis) {
        MetaGroup g = this.getMetaTemplateGroup(publicId);
        return g == null ? null : g.getMetaTemplate(axis);
    }

    public MetaGroup addGroup(String publicId) {
        MetaGroup g = this.getMetaTemplateGroup(publicId);
        if (g != null) {
            return g;
        }
        g = MetaElementFactory.instance.createGroup(null);
        g.setUri(publicId);
        this.groups.put(publicId, g);
        return g;
    }

    public boolean isOverriding() {
        for (MetaGroup g : this.groups.values()) {
            if (!g.isOverriding()) continue;
            return true;
        }
        return false;
    }

    public void commitToParent() {
        if (this.parent == null) {
            return;
        }
        for (MetaGroup p : this.getMetaTemplateGroups()) {
            p.commitToParent();
        }
    }

    public void loadFromParent(int depth) {
        if (this.parent == null) {
            return;
        }
        for (MetaGroup p : this.getMetaTemplateGroups()) {
            p.loadFromParent(depth);
        }
    }
}

