/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.navigator.decorator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.navigator.decorator.DecoratorConstants;
import org.jboss.tools.common.model.ui.navigator.decorator.ICustomVariable;

public class Variable
implements DecoratorConstants {
    public static Variable NAME = new Variable("name", "default label");
    String name;
    String parameters = "";
    String description;
    ICustomVariable custom;

    public Variable() {
    }

    Variable(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRuleText() {
        return "{" + this.name + this.parameters + "}";
    }

    public String toString() {
        if (this.description == null || this.description.length() == 0) {
            return this.name;
        }
        return String.valueOf(this.name) + this.parameters + " - " + this.description;
    }

    public void load(IConfigurationElement element) {
        this.name = element.getAttribute("name");
        int i = this.name.indexOf(40);
        if (i >= 0) {
            this.parameters = this.name.substring(i);
            this.name = this.name.substring(0, i);
        }
        this.description = element.getAttribute("description");
        String cls = element.getAttribute("class");
        if (cls != null && cls.length() > 0) {
            try {
                this.custom = (ICustomVariable)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (ClassCastException e1) {
                ModelUIPlugin.getPluginLog().logError("Attribute class must be instanceof ICustomVariable", (Throwable)e1);
            }
        }
    }
}

