/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import java.lang.reflect.InvocationTargetException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.forms.DefaultFormContainer;
import org.jboss.tools.common.model.ui.forms.Form;
import org.jboss.tools.common.model.ui.forms.FormContainer;
import org.jboss.tools.common.model.ui.forms.IForm;
import org.jboss.tools.common.model.ui.forms.IFormData;
import org.jboss.tools.common.model.ui.forms.IFormLayoutData;
import org.jboss.tools.common.model.ui.forms.XModelObjectFormFactory;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class LayouredFormFactory
extends XModelObjectFormFactory {
    private IFormLayoutData formLayoutData;

    public LayouredFormFactory(XModelObject xmo) {
        super(xmo);
        this.initialize();
    }

    private void initialize() {
        String formLayoutDataClassName = null;
        formLayoutDataClassName = this.getXModelObject().getModelEntity().getProperty("formLayout");
        Class formLayoutDataClass = ModelFeatureFactory.getInstance().getFeatureClass(formLayoutDataClassName);
        try {
            this.formLayoutData = (IFormLayoutData)formLayoutDataClass.getMethod("getInstance", null).invoke(null, null);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public IForm getForm() {
        DefaultFormContainer form = null;
        String entity = this.getXModelObject().getModelEntity().getName();
        IFormData formData = this.formLayoutData.getFormData(entity);
        if (formData == null) {
            String message = "Cannot find form for entity " + entity + ".";
            ModelUIPlugin.getPluginLog().logError(message);
        } else {
            form = formData.getForms() != null ? new FormContainer(formData) : new DefaultFormContainer(new Form(formData));
        }
        return form;
    }
}

