/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.dialog;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.jboss.tools.common.model.ui.dialog.FileFilter;

class FSDialog
extends ElementTreeSelectionDialog {
    private String m;
    private String seed;
    FileFilter z;
    boolean everything = true;

    public FSDialog(Shell parent, IResource root, List files, String title, String message, String[] extensions, String mess, String seed) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.seed = seed;
        this.setTitle(title);
        this.setMessage(message);
        this.z = new FileFilter(files, extensions);
        this.m = mess;
        this.everything = true;
        this.setInput(root != null ? root : ResourcesPlugin.getWorkspace().getRoot());
        this.setSorter((ViewerSorter)new ResourceSorter(1));
        this.setValidator(this.createValidator());
    }

    private ISelectionStatusValidator createValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] os) {
                if (os.length == 0) {
                    return new Status(4, "org.jboss.tools.common.model.ui", 0, "", null);
                }
                int i = 0;
                while (i < os.length) {
                    if (!(os[i] instanceof IFile)) {
                        return new Status(4, "org.jboss.tools.common.model.ui", 0, "", null);
                    }
                    ++i;
                }
                return new Status(0, "org.jboss.tools.common.model.ui", 0, "", null);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        if (this.m != null) {
            Button b = this.createButton(parent, result);
            this.setSeed();
            this.z.considerExtension(this.everything);
            this.getTreeViewer().addFilter((ViewerFilter)this.z);
            if (!this.everything) {
                b.setSelection(true);
            }
            b.addSelectionListener(this.createListener(b));
        }
        FSDialog.applyDialogFont((Control)result);
        return result;
    }

    private Button createButton(Composite parent, Composite p2) {
        Button b = new Button(p2, 32);
        b.setText(this.m);
        b.setFont(parent.getFont());
        return b;
    }

    private void setSeed() {
        if (this.seed == null) {
            return;
        }
        IPath path = Path.fromPortableString((String)this.seed);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        this.setInitialSelection(resource);
    }

    private SelectionListener createListener(final Button b) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FSDialog.this.everything = !b.getSelection();
                FSDialog.this.z.considerExtension(!FSDialog.this.everything);
                FSDialog.this.getTreeViewer().refresh();
            }
        };
    }
}

