/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorDialog;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class StringTwoButtonFieldEditor
extends StringButtonFieldEditor
implements IFieldEditor,
IPropertyChangeListener,
PropertyChangeListener,
IPropertyFieldEditor {
    protected PropertyEditorDialog editorDialog;
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected IValueChangeListener valueChangeListener;
    protected Composite composite;
    protected String[] buttonLabels;
    protected Button button1;
    protected Button button2;

    public StringTwoButtonFieldEditor() {
    }

    public StringTwoButtonFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
        this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
        this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
    }

    protected String changePressed() {
        this.editorDialog = new PropertyEditorDialog(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), this.propertyEditor);
        int i = this.editorDialog.open();
        return i != 0 ? null : this.valueProvider.getStringValue(false);
    }

    protected String change2Pressed() {
        return this.valueProvider.getStringValue(false);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Composite control = this.getTextChangeControl(parent);
        control.setLayoutData((Object)new GridData(768));
    }

    protected Composite getTextChangeControl(Composite parent) {
        if (this.composite == null) {
            this.createTextChangeControl(parent);
        }
        return this.composite;
    }

    protected Control getChange1Control(Composite parent) {
        this.button1 = this.getChangeControl(parent);
        String buttonLabel = this.buttonLabels != null && this.buttonLabels.length > 1 ? this.buttonLabels[0] : JFaceResources.getString((String)"openBrowse");
        this.button1.setText(buttonLabel);
        return this.button1;
    }

    protected Control getChange2Control(Composite parent) {
        if (this.button2 == null) {
            int style = this.getSettings().getStyle("Button.Style");
            if (style == -1) {
                style = 0;
            }
            if (style == 0) {
                style = 8;
            }
            Color bg = this.getSettings().getColor("Button.Background");
            Color fg = this.getSettings().getColor("Button.Foreground");
            Font font = this.getSettings().getFont("Button.Font");
            this.button2 = new Button(parent, style);
            this.button2.setFont(font);
            this.button2.setBackground(bg);
            this.button2.setBackground(bg);
            this.button2.setForeground(fg);
            String buttonLabel = this.buttonLabels != null && this.buttonLabels.length > 1 ? this.buttonLabels[1] : JFaceResources.getString((String)"open");
            this.button2.setText(buttonLabel);
            this.button2.setFont(parent.getFont());
            this.button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String newValue = StringTwoButtonFieldEditor.this.change2Pressed();
                    if (newValue != null) {
                        StringTwoButtonFieldEditor.this.setStringValue(newValue);
                    }
                }
            });
            this.button2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    StringTwoButtonFieldEditor.this.button2 = null;
                }
            });
        } else {
            this.checkParent((Control)this.button2, parent);
        }
        return this.button2;
    }

    protected Control createTextChangeControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        Control textControl = this.createTextControl(this.composite);
        GridData gd = new GridData(768);
        textControl.setLayoutData((Object)gd);
        Composite control = new Composite(this.composite, 0);
        control.setBackground(parent.getBackground());
        gd = new GridData();
        gd.widthHint = 5;
        gd.heightHint = 5;
        control.setLayoutData((Object)gd);
        control = this.getChange1Control(this.composite);
        gd = new GridData();
        gd.heightHint = textControl.computeSize((int)-1, (int)-1).y;
        control.setLayoutData((Object)gd);
        control = new Composite(this.composite, 0);
        control.setBackground(parent.getBackground());
        gd = new GridData();
        gd.widthHint = 5;
        gd.heightHint = 5;
        control.setLayoutData((Object)gd);
        control = this.getChange2Control(this.composite);
        gd = new GridData();
        gd.heightHint = textControl.computeSize((int)-1, (int)-1).y;
        control.setLayoutData((Object)gd);
        if (this.valueProvider != null) {
            this.getTextField().setText("" + this.valueProvider.getValue());
        }
        return this.composite;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.valueChangeListener != null && "field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            Object v = evt.getNewValue();
            this.valueProvider.removeValueChangeListener(this);
            this.setStringValue(v == null ? "" : v.toString());
            this.valueProvider.addValueChangeListener(this);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        Control[] controls = this.getControls(parent);
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                Control[] compositeChildren = ((Composite)controls[i]).getChildren();
                int j = 0;
                while (j < compositeChildren.length) {
                    compositeChildren[j++].setEnabled(enabled);
                }
            }
            controls[i].setEnabled(enabled);
            ++i;
        }
    }

    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getTextChangeControl(parent)};
    }

    public String[] getButtonLabels() {
        return this.buttonLabels;
    }

    public void setButtonLabels(String[] strings) {
        this.buttonLabels = strings;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getTextControl() != null) {
            this.getTextControl().setEnabled(enabled);
        }
        if (this.button1 != null) {
            this.button1.setEnabled(enabled);
        }
        if (this.button2 != null) {
            this.button2.setEnabled(enabled);
        }
    }
}

