/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.StringFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class StringFieldEditorEx
extends StringFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected IValueChangeListener valueChangeListener;

    public StringFieldEditorEx() {
    }

    public StringFieldEditorEx(IWidgetSettings settings) {
        super(settings);
    }

    public StringFieldEditorEx(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    protected void init() {
        this.setStringValue(this.valueProvider.getStringValue(true));
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
        }
        this.init();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", event.getOldValue(), event.getNewValue());
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.valueProvider.removeValueChangeListener(this);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            Object v = evt.getNewValue();
            this.setStringValue(v == null ? "" : v.toString());
        }
        this.valueProvider.addValueChangeListener(this);
    }

    public Control createTextControl(Composite parent) {
        String value;
        Control control = super.createTextControl(parent);
        Text text = this.getTextField();
        if (this.valueProvider != null && !(value = this.valueProvider.getStringValue(true)).equals(text.getText())) {
            text.setText(value.toString());
        }
        return control;
    }

    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createTextControl(parent)};
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isAlwaysReadOnly() {
        block4: {
            if (this.propertyEditor == null) {
                return false;
            }
            input = this.propertyEditor.getInput();
            if (!(input instanceof DefaultValueAdapter)) break block4;
            a = (DefaultValueAdapter)input;
            o = a.getModelObject();
            if (o != null && !o.isObjectEditable()) ** GOTO lbl10
            return false;
lbl-1000:
            // 1 sources

            {
                o = o.getParent();
lbl10:
                // 2 sources

                ** while (o != null && o.getFileType() < 2)
            }
lbl11:
            // 1 sources

            if (o == null) {
                return false;
            }
            entity = o.getModelEntity().getName();
            if (entity.indexOf("Jar") >= 0) {
                return true;
            }
        }
        return false;
    }

    public void setStringValue(String value) {
        if (!this.isSameValue(value)) {
            super.setStringValue(value);
        }
    }

    boolean isSameValue(String newValue) {
        DefaultValueAdapter a;
        Text text = this.getTextField();
        if (text == null || text.isDisposed() || newValue == null) {
            return false;
        }
        String oldTextValue = text.getText();
        if (this.propertyEditor != null && this.propertyEditor.getInput() instanceof DefaultValueAdapter && (a = (DefaultValueAdapter)this.propertyEditor.getInput()).getAttribute().isTrimmable()) {
            return oldTextValue != null && oldTextValue.trim().equals(newValue.trim());
        }
        return oldTextValue != null && oldTextValue.equals(newValue);
    }

    protected void addContentAssist(Text text) {
        if (this.propertyEditor != null && this.propertyEditor.getInput() instanceof DefaultValueAdapter) {
            DefaultValueAdapter valueAdapter = (DefaultValueAdapter)this.propertyEditor.getInput();
            AttributeContentProposalProviderFactory.registerContentAssist(valueAdapter, (Control)text);
        }
    }
}

