/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.BorderedControl;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioArrayFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    IPropertyEditor propertyEditor;
    IValueChangeListener valueChangeListener;
    IValueProvider valueProvider;
    ILabelProvider labelProvider;
    IListContentProvider listContentProvider;
    private String stringValue = "";
    private boolean isValid;
    private Composite panel;
    private Button[] radioButtons;
    private String[] tags = new String[0];
    private int style = 0;
    boolean modifyLock = false;
    Object[] elements;

    public RadioArrayFieldEditor() {
    }

    public RadioArrayFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public RadioArrayFieldEditor(String name, String labelText, List<String> tags, Composite parent) {
        this.init(name, labelText);
        if (tags != null) {
            this.tags = tags.toArray(new String[tags.size()]);
        }
        this.createControl(parent);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.panel.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        this.panel = this.getPanelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.panel.setLayoutData((Object)gd);
    }

    public int getNumberOfControls() {
        return 2;
    }

    @Override
    public Control[] getControls(Composite parent) {
        Object label = null;
        label = this.makeGroup() || this.hideLabel() ? new Label(parent, 0) : this.getLabelComposite(parent);
        return new Control[]{label, this.getPanelControl(parent)};
    }

    public Composite getPanelControl(Composite parent) {
        if (this.panel == null) {
            Border border = this.getSettings().getBorder("Combo.Border");
            boolean makeGroup = this.makeGroup();
            if (border != null) {
                BorderedControl borderedControl = new BorderedControl(parent, 0, border);
                if (!makeGroup) {
                    this.panel = new Composite((Composite)borderedControl, 0x800000);
                } else {
                    Group g = new Group((Composite)borderedControl, 16);
                    g.setText(this.propertyEditor.getLabelText());
                    this.panel = g;
                }
            } else if (!makeGroup) {
                this.panel = new Composite(parent, this.getStyle());
            } else {
                Group g = new Group(parent, 16);
                g.setText(this.propertyEditor.getLabelText());
                this.panel = g;
            }
            int k = this.getTags().length;
            if (!this.isHorizontalLayout() && (k != 3 || makeGroup)) {
                k = 1;
            }
            GridLayout layout = new GridLayout(k, false);
            this.panel.setLayout((Layout)layout);
            this.modifyLock = true;
            this.setItems(this.getTags());
            this.stringValue = this.valueProvider.getStringValue(true);
            this.setSelectedValue(this.stringValue);
            this.modifyLock = false;
            this.panel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    RadioArrayFieldEditor.this.panel = null;
                    RadioArrayFieldEditor.this.radioButtons = new Button[0];
                }
            });
        }
        return this.panel;
    }

    boolean makeGroup() {
        Object input = this.propertyEditor.getInput();
        if (input instanceof DefaultValueAdapter) {
            DefaultValueAdapter adapter = (DefaultValueAdapter)input;
            return "true".equals(adapter.getAttribute().getProperty("border"));
        }
        return false;
    }

    boolean hideLabel() {
        Object input = this.propertyEditor.getInput();
        if (input instanceof DefaultValueAdapter) {
            DefaultValueAdapter adapter = (DefaultValueAdapter)input;
            return "false".equals(adapter.getAttribute().getProperty("label"));
        }
        return false;
    }

    boolean isHorizontalLayout() {
        Object input = this.propertyEditor.getInput();
        if (input instanceof DefaultValueAdapter) {
            DefaultValueAdapter adapter = (DefaultValueAdapter)input;
            return "true".equals(adapter.getAttribute().getProperty("horizontal"));
        }
        return false;
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        String oldValue = this.stringValue;
        String newValue = this.getSelectedValue();
        this.valueProvider.removeValueChangeListener(this);
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
        this.valueChangeListener.valueChange(event);
        this.stringValue = newValue;
        this.valueProvider.addValueChangeListener(this);
    }

    private String[] getTags() {
        this.elements = this.listContentProvider.getElements(this);
        this.tags = new String[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            this.tags[i] = this.labelProvider.getText(this.elements[i]);
            ++i;
        }
        return this.tags;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int i) {
        this.style = i;
    }

    protected void setStringValue(String newValue) {
        String oldValue = this.stringValue;
        this.stringValue = newValue;
        this.modifyLock = true;
        this.setSelectedValue(newValue);
        this.modifyLock = false;
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
        this.valueChangeListener.valueChange(event);
    }

    private static Object mapFromTo(Object[] from, Object[] to, Object value) {
        if (from == null || from.length == 0 || to == null || to.length == 0) {
            return value;
        }
        int index = Arrays.asList(from).indexOf(value);
        return index == -1 ? value : to[index];
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
            this.listContentProvider = (IListContentProvider)propertyEditor.getAdapter(IListContentProvider.class);
        }
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", RadioArrayFieldEditor.mapFromTo(this.tags, this.elements, event.getOldValue()), RadioArrayFieldEditor.mapFromTo(this.tags, this.elements, event.getNewValue()));
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        Object v;
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            v = evt.getNewValue();
            this.valueProvider.removeValueChangeListener(this);
            this.setStringValue(v == null ? "" : v.toString());
            this.valueProvider.addValueChangeListener(this);
        }
        if ("IPropertyEditor.listContent".equals(evt.getPropertyName())) {
            v = this.getSelectedValue();
            this.valueProvider.removeValueChangeListener(this);
            String[] tags = this.getTags();
            this.setItems(tags);
            this.setSelectedValue((String)v);
        }
    }

    private void setItems(String[] tags) {
        int i;
        this.tags = tags;
        if (this.radioButtons != null) {
            i = 0;
            while (i < this.radioButtons.length) {
                this.radioButtons[i].dispose();
                ++i;
            }
        }
        if (this.panel == null) {
            return;
        }
        this.radioButtons = new Button[tags.length];
        i = 0;
        while (i < tags.length) {
            this.radioButtons[i] = this.createRadio(tags[i]);
            ++i;
        }
    }

    private Button createRadio(String tag) {
        Button b = new Button(this.panel, 16);
        GridData d = new GridData(768);
        b.setLayoutData((Object)d);
        b.setText(tag);
        b.addSelectionListener((SelectionListener)new SL(b));
        return b;
    }

    private String getSelectedValue() {
        if (this.radioButtons == null) {
            return "";
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            if (this.radioButtons[i].getSelection()) {
                return this.tags[i];
            }
            ++i;
        }
        return "";
    }

    private void setSelectedValue(String v) {
        if (this.radioButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            this.radioButtons[i].setSelection(v.equals(this.tags[i]));
            ++i;
        }
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        if (this.radioButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            this.radioButtons[i].setEnabled(enabled);
            ++i;
        }
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void delete() {
    }

    class SL
    implements SelectionListener {
        Button b;

        SL(Button b) {
            this.b = b;
        }

        public void widgetSelected(SelectionEvent e) {
            if (RadioArrayFieldEditor.this.modifyLock || RadioArrayFieldEditor.this.radioButtons == null) {
                return;
            }
            RadioArrayFieldEditor.this.modifyLock = true;
            int i = 0;
            while (i < RadioArrayFieldEditor.this.radioButtons.length) {
                if (RadioArrayFieldEditor.this.radioButtons[i] != this.b) {
                    RadioArrayFieldEditor.this.radioButtons[i].setSelection(false);
                }
                ++i;
            }
            RadioArrayFieldEditor.this.setSelectedValue(this.b.getText());
            RadioArrayFieldEditor.this.valueChanged();
            RadioArrayFieldEditor.this.modifyLock = false;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

