/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter.custom;

import java.util.StringTokenizer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class ColoredFontData {
    public static final ColoredFontData DEFAULT = new ColoredFontData();
    FontData data;
    RGB color;

    static {
        try {
            ColoredFontData.DEFAULT.data = Display.getDefault().getSystemFont().getFontData()[0];
            ColoredFontData.DEFAULT.color = Display.getDefault().getSystemColor(2).getRGB();
        }
        catch (SWTException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public FontData getFontData() {
        return this.data;
    }

    public RGB getColor() {
        return this.color;
    }

    public static ColoredFontData toFontData(String text) {
        if (text == null || text.length() == 0) {
            return DEFAULT;
        }
        StringTokenizer st = new StringTokenizer(text, ",");
        int q = 0;
        FontData data = new FontData(DEFAULT.getFontData().getName(), DEFAULT.getFontData().getHeight(), DEFAULT.getFontData().getStyle());
        RGB color = DEFAULT.getColor();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (q == 0) {
                if (!"default".equals(t)) {
                    data.setName(t);
                }
            } else if (t.startsWith("size=")) {
                data.setHeight(ColoredFontData.getInt(t.substring(5), data.getHeight()));
            } else if (t.startsWith("style=")) {
                data.setStyle(ColoredFontData.getInt(t.substring(6), data.getStyle()));
            } else if (t.startsWith("color=")) {
                String sc = t.substring(6);
                int red = color.red;
                int green = color.green;
                int blue = color.blue;
                int i = sc.indexOf(45);
                if (i < 0) continue;
                red = ColoredFontData.getInt(sc.substring(0, i), red);
                if ((i = (sc = sc.substring(i + 1)).indexOf(45)) < 0) continue;
                green = ColoredFontData.getInt(sc.substring(0, i), green);
                sc = sc.substring(i + 1);
                blue = ColoredFontData.getInt(sc, blue);
                color = new RGB(red, green, blue);
            }
            ++q;
        }
        ColoredFontData d = new ColoredFontData();
        d.data = data;
        d.color = color;
        return d;
    }

    private static int getInt(String s, int def) {
        if (s == null || s.length() == 0) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return def;
        }
    }

    public static String toString(FontData data, RGB rgb) {
        StringBuffer sb = new StringBuffer();
        if (data.getName().equals(DEFAULT.getFontData().getName())) {
            sb.append("default");
        } else {
            sb.append(data.getName());
        }
        sb.append(",size=" + data.getHeight());
        sb.append(",style=" + data.getStyle());
        if (!ColoredFontData.DEFAULT.color.equals((Object)rgb)) {
            sb.append(",color=" + rgb.red + "-" + rgb.green + "-" + rgb.blue);
        }
        return sb.toString();
    }
}

