/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.IAttributeContentProposalProvider;
import org.jboss.tools.common.model.ui.attribute.IValueFilter;
import org.jboss.tools.common.model.ui.attribute.adapter.TypeContentProposalProvider;
import org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkCueLabelProvider;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class JavaClassContentAssistProvider
implements IAttributeContentProposalProvider {
    XModelObject object;
    XAttribute attribute;
    IValueFilter valueFilter = null;

    public IContentProposalProvider getContentProposalProvider() {
        IProject project = (IProject)this.object.getModel().getProperties().get("project");
        return project == null ? null : new TypeContentProposalProvider(project, 0, this.valueFilter);
    }

    public int getProposalAcceptanceStyle() {
        return 2;
    }

    public void init(XModelObject object, XEntityData data, XAttribute attribute) {
        this.object = object;
        this.attribute = attribute;
        this.createValueFilter();
    }

    void createValueFilter() {
        if (this.attribute == null) {
            return;
        }
        String cls = this.attribute.getProperty("valueFilter");
        if (cls == null || cls.length() == 0) {
            return;
        }
        try {
            this.valueFilter = (IValueFilter)ModelFeatureFactory.getInstance().createFeatureInstance(cls);
        }
        catch (ClassCastException exc) {
            ModelUIPlugin.getPluginLog().logError((Throwable)exc);
        }
        if (this.valueFilter != null && !this.valueFilter.init(this.object, this.attribute)) {
            this.valueFilter = null;
        }
    }

    public boolean isRelevant(XModelObject object, XAttribute attribute) {
        if (object == null || attribute == null) {
            return false;
        }
        String editorName = attribute.getEditor().getName();
        return editorName != null && editorName.indexOf("AccessibleJava") >= 0;
    }

    public LabelProvider getCustomLabelProbider() {
        return JavaHyperlinkCueLabelProvider.INSTANCE;
    }

    public void dispose() {
        this.object = null;
        this.attribute = null;
    }
}

