/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintProperties;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.markers.XMarkerManager;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.IValueFilter;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class DefaultValueAdapter
implements IModelPropertyEditorAdapter,
IAdaptable {
    protected Object value = "";
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected PropertyChangeSupport pcs2 = new PropertyChangeSupport(this);
    protected XModel model;
    protected XAttribute attribute;
    protected XModelObject modelObject;
    protected XAttributeData attributeData;
    protected static final int UNKNOW_TARGET = -1;
    protected static final int MODELOBJECT_TARGET = 0;
    protected static final int ATTRIBUTEDATA_TARGET = 1;
    protected int storeTarget = -1;
    protected boolean autoStore = true;
    protected boolean storeLocked = false;
    protected String invalidValue = null;
    protected String lastCorrectValue = null;
    protected String currentError = null;
    boolean valueFilterChecked = false;
    IValueFilter valueFilter = null;
    protected XActionWrapper labelAction;
    protected IActionProvider actionProvider;

    public void store() {
        if (this.isStoreLocked()) {
            return;
        }
        if (this.storeTarget == 0) {
            String v = this.getStringValue(true);
            if (v != null && this.attribute.isTrimmable()) {
                v = v.trim();
            }
            String n = this.attribute.getName();
            if (this.modelObject.isActive()) {
                this.currentError = ((XModelImpl)this.modelObject.getModel()).getError(this.modelObject, n, v);
                if (this.currentError != null) {
                    this.invalidValue = this.getStringValue(true);
                    this.lastCorrectValue = this.modelObject.getAttributeValue(n);
                    if (this.pcs2 != null) {
                        this.pcs2.firePropertyChange("IPropertyEditor.error", Boolean.FALSE, Boolean.TRUE);
                    }
                    this.fireValueChange(v, v);
                    return;
                }
                boolean changed = this.invalidValue != null;
                this.invalidValue = null;
                this.lastCorrectValue = null;
                if (changed && this.pcs2 != null) {
                    this.pcs2.firePropertyChange("IPropertyEditor.error", Boolean.TRUE, Boolean.FALSE);
                }
                try {
                    this.modelObject.getModel().editObjectAttribute(this.modelObject, n, v);
                }
                catch (XModelException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                this.modelObject.setAttributeValue(this.attribute.getName(), this.getValue().toString());
            }
            String v1 = this.modelObject.getAttributeValue(n);
            if (!v1.equals(v)) {
                this.setValue(v1);
                this.fireValueChange(v, v1);
            }
        } else if (this.attributeData != null) {
            this.attributeData.setValue(this.getStringValue(true));
        }
    }

    public void load() {
        if (this.storeTarget == 0) {
            String value = this.modelObject.getAttributeValue(this.attribute.getName());
            if (this.currentError != null && this.invalidValue != null && value != null && value.equals(this.lastCorrectValue)) {
                return;
            }
            this.setValue(value);
        } else {
            this.setValue(this.attributeData.getValue());
        }
    }

    public void setValue(Object value) {
        if (this.value == value || this.value != null && this.value.equals(value)) {
            return;
        }
        Object oldValue = this.value;
        this.value = value;
        this.fireValueChange(oldValue, this.value);
    }

    public void fireValueChange(Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("IPropertyEditor.value", oldValue, newValue);
        }
    }

    public void fireEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void addValueChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.addPropertyChangeListener(l);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void removeValueChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    public void addErrorStateListener(PropertyChangeListener l) {
        if (this.pcs2 != null) {
            this.pcs2.addPropertyChangeListener(l);
        }
    }

    public void valueChange(PropertyChangeEvent event) {
        this.setValue(event.getNewValue());
        if (this.isAutoStore()) {
            this.store();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IValueProvider.class) {
            return this;
        }
        if (adapter == IValueChangeListener.class) {
            return this;
        }
        if (adapter == IAttributeErrorProvider.class) {
            return this;
        }
        if (adapter == IValueFilter.class) {
            if (this.valueFilterChecked) {
                return this.valueFilter;
            }
            this.valueFilterChecked = true;
            if (this.valueFilter == null) {
                XAttribute a;
                Object object = this.attribute != null ? this.attribute : (a = this.attributeData != null ? this.attributeData.getAttribute() : null);
                if (a == null) {
                    return null;
                }
                String cls = a.getProperty("valueFilter");
                if (cls == null || cls.length() == 0) {
                    return null;
                }
                try {
                    this.valueFilter = (IValueFilter)ModelFeatureFactory.getInstance().createFeatureInstance(cls);
                }
                catch (ClassCastException exc) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)exc);
                }
                if (this.valueFilter != null && !this.valueFilter.init(this.getModelObject(), a)) {
                    this.valueFilter = null;
                }
                return this.valueFilter;
            }
        }
        if (adapter == IActionProvider.class) {
            return this.getActionProvider();
        }
        return null;
    }

    public XAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(XAttribute attribute) {
        this.attribute = attribute;
    }

    public XAttributeData getAttributeData() {
        return this.attributeData;
    }

    public void setAttributeData(XAttributeData data) {
        this.attributeData = data;
        this.storeTarget = 1;
    }

    public XModelObject getModelObject() {
        return this.modelObject;
    }

    public void setModelObject(XModelObject object) {
        this.modelObject = object;
        this.storeTarget = 0;
    }

    public boolean isAutoStore() {
        return this.autoStore;
    }

    public void setAutoStore(boolean b) {
        this.autoStore = b;
    }

    public boolean isStoreLocked() {
        return this.storeLocked;
    }

    public void setStoreLocked(boolean b) {
        this.storeLocked = b;
    }

    public XModel getModel() {
        return this.model;
    }

    public void setModel(XModel model) {
        this.model = model;
    }

    public String getStringValue(boolean returnNullAsEmptyString) {
        Object o = this.getValue();
        return o != null ? o.toString() : (returnNullAsEmptyString ? "" : null);
    }

    public void dispose() {
        this.pcs = null;
    }

    public boolean hasErrors() {
        if (1 == this.storeTarget) {
            return false;
        }
        if (this.invalidValue != null && this.currentError != null) {
            return true;
        }
        return this.attribute != null && XMarkerManager.getInstance().hasErrors(this.modelObject, this.attribute.getName());
    }

    public String getError() {
        if (this.modelObject == null || this.attribute == null) {
            return null;
        }
        if (1 != this.storeTarget && this.invalidValue != null && this.currentError != null) {
            return this.currentError;
        }
        return XMarkerManager.getInstance().getError(this.modelObject, this.attribute.getName());
    }

    protected IActionProvider getActionProvider() {
        if (this.actionProvider == null) {
            String actionPath = null;
            if (this.attribute != null) {
                actionPath = this.attribute.getConstraint() instanceof XAttributeConstraintProperties ? ((XAttributeConstraintProperties)this.attribute.getConstraint()).getProperties().getProperty("linkAction") : this.attribute.getProperty("linkAction");
            }
            if (actionPath != null) {
                this.actionProvider = new ActionProvider();
                XAction xaction = XActionInvoker.getAction((String)actionPath, (XModelObject)this.modelObject);
                XActionWrapper xActionWrapper = this.labelAction = xaction != null ? new XActionWrapper(xaction) : null;
                if (this.labelAction != null) {
                    this.labelAction.setXModelObject(this.getModelObject());
                }
            }
        }
        return this.actionProvider;
    }

    protected class ActionProvider
    implements IActionProvider {
        public IAction getAction(String actionName) {
            if ("Label.Selected".equals(actionName)) {
                return DefaultValueAdapter.this.labelAction;
            }
            return null;
        }

        public IAction[] getActions() {
            return new IAction[]{DefaultValueAdapter.this.labelAction};
        }

        public void update(ISelection selection) {
        }
    }

    protected class XActionWrapper
    extends Action {
        private XAction xaction = null;

        public XActionWrapper(XAction xaction) {
            this.xaction = xaction;
        }

        public void setXModelObject(XModelObject xmo) {
            if (xmo != null && this.xaction != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.xaction != null) {
                if (this.xaction.isEnabled(DefaultValueAdapter.this.getModelObject())) {
                    XActionInvoker.invoke((String)this.xaction.getPath(), (XModelObject)DefaultValueAdapter.this.modelObject, (Properties)new Properties());
                } else {
                    Shell shell = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)"Resource does not exist.");
                }
            }
        }
    }
}

