/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action;

import java.util.Properties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.ModelContributionManager;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;

public abstract class XMenuInvoker
implements MouseListener,
KeyListener {
    protected Viewer viewer;
    protected boolean onKeyRelease = false;
    ModelContributionManager standardInvoker;

    public void setStandardInvoker(ModelContributionManager standardInvoker) {
        this.standardInvoker = standardInvoker;
    }

    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    public void setOnKeyRelease(boolean b) {
        this.onKeyRelease = b;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.standardInvoker != null) {
            XModelObject eo = this.getModelObjectAt(new Point(e.x, e.y));
            XModelObject o = this.getSelectedModelObject();
            if (o == null && eo == null) {
                return;
            }
            Object[] os = this.getSelectedModelObjects();
            if (eo != null && (o == null || os == null || os.length < 2)) {
                o = eo;
                os = null;
            } else if (this.isIncluded(eo, (XModelObject[])os)) {
                o = eo;
            }
            if (os != null && os.length > 0) {
                this.standardInvoker.setSelection((ISelection)new StructuredSelection(os));
            } else if (o != null) {
                this.standardInvoker.setSelection((ISelection)new StructuredSelection((Object)o));
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        this.handleMouseUp(e);
    }

    protected void handleMouseUp(MouseEvent e) {
        if (e.button == 3 && this.standardInvoker == null) {
            XModelObject eo = this.getModelObjectAt(new Point(e.x, e.y));
            XModelObject o = this.getSelectedModelObject();
            if (o == null && eo == null) {
                return;
            }
            XModelObject[] os = this.getSelectedModelObjects();
            if (eo != null && (o == null || os == null || os.length < 2)) {
                o = eo;
                os = null;
            } else if (this.isIncluded(eo, os)) {
                o = eo;
            }
            XModelObjectActionList l = new XModelObjectActionList(this.getActionList(o), o, os, (Object)new Object[]{o, this.getRunningProperties()});
            Menu menu = l.createMenu(this.viewer.getControl());
            menu.setVisible(true);
        }
        if (e.button == 1) {
            XModelObject o = this.getSelectedModelObject();
            if (o == null) {
                return;
            }
            if ("true".equals(o.get("overlapped"))) {
                XActionInvoker.invoke((String)"Open", (XModelObject)o, (Properties)new Properties());
            }
        }
    }

    private boolean isIncluded(XModelObject object, XModelObject[] objects) {
        if (object == null || objects == null) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == object) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected XActionList getActionList(XModelObject o) {
        return o.getModelEntity().getActionList();
    }

    public abstract XModelObject getSelectedModelObject();

    public XModelObject[] getSelectedModelObjects() {
        return null;
    }

    public XModelObject getModelObjectAt(Point p) {
        return null;
    }

    public void keyPressed(KeyEvent e) {
        if (!this.onKeyRelease) {
            this.processKey(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.onKeyRelease) {
            this.processKey(e);
        }
    }

    protected void processKey(KeyEvent e) {
        if ((e.stateMask & 0x40000) != 0 && e.keyCode == 99) {
            this.invoke("CopyActions.Copy");
        } else if ((e.stateMask & 0x40000) != 0 && e.keyCode == 120) {
            this.invoke("CopyActions.Cut");
        } else if ((e.stateMask & 0x40000) != 0 && e.keyCode == 118) {
            this.invoke("CopyActions.Paste");
        } else if (e.stateMask == 0 && e.character == '\u007f') {
            this.invoke("DeleteActions.Delete");
        }
    }

    private void invoke(String actionPath) {
        XModelObject object = this.getSelectedModelObject();
        if (object == null) {
            return;
        }
        XModelObject[] objects = this.getSelectedModelObjects();
        if (DnDUtil.getEnabledAction(object, objects, actionPath) == null) {
            return;
        }
        if (objects == null) {
            XActionInvoker.invoke((String)actionPath, (XModelObject)object, (Properties)this.getRunningProperties());
        } else {
            XActionInvoker.invoke((String)actionPath, (XModelObject)object, (XModelObject[])objects, (Properties)this.getRunningProperties());
        }
    }

    private Properties getRunningProperties() {
        Properties p = new Properties();
        this.fillRunningProperties(p);
        return p;
    }

    protected void fillRunningProperties(Properties p) {
    }
}

