/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.editor.ErrorSelectionListener;
import org.jboss.tools.common.editor.Lbl;
import org.jboss.tools.common.model.XModelObject;

public class ErrorMode {
    private ScrolledComposite errors = null;
    Composite c = null;
    private ArrayList<Lbl> labels = new ArrayList();
    String es = "";
    ErrorSelectionListener listener;
    boolean visible = true;

    public void addErrorSelectionListener(ErrorSelectionListener listener) {
        this.listener = listener;
        int i = 0;
        while (i < this.labels.size()) {
            Lbl l = this.labels.get(i);
            l.listener = listener;
            ++i;
        }
    }

    public void setEnabled(boolean b) {
        if (this.visible == b) {
            return;
        }
        this.visible = b;
        if (this.errors != null && !this.errors.isDisposed()) {
            this.errors.setVisible(b);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEnabled() {
        return this.errors != null && this.errors.isVisible();
    }

    public boolean isDisposed() {
        return this.errors == null || this.errors.isDisposed();
    }

    public void dispose() {
        if (this.errors != null) {
            if (!this.errors.isDisposed()) {
                this.errors.dispose();
            }
            this.errors = null;
            this.labels.clear();
            this.es = "";
        }
        this.listener = null;
        this.c = null;
    }

    public Control createControl(Composite composite) {
        this.errors = new ScrolledComposite(composite, 2816);
        this.errors.setBackground(Display.getDefault().getSystemColor(1));
        return this.errors;
    }

    public Control getControl() {
        return this.errors;
    }

    private void createC() {
        if (this.c != null && !this.c.isDisposed()) {
            this.c.dispose();
        }
        this.c = new Composite((Composite)this.errors, 0);
        this.errors.setContent((Control)this.c);
        GridLayout l = new GridLayout();
        l.verticalSpacing = 0;
        l.marginWidth = 0;
        this.c.setLayout((Layout)l);
        this.c.setBackground(Display.getDefault().getSystemColor(1));
    }

    public void update(XModelObject o) {
        this.update(o.get("errors"));
    }

    public void update(String err) {
        Lbl lb;
        String s = err;
        if (s == null) {
            s = "";
        }
        if (this.es.equals(s)) {
            return;
        }
        this.createC();
        this.labels.clear();
        String[] el = this.getErrors(s);
        int i = 0;
        while (i < el.length) {
            lb = null;
            if (i < this.labels.size()) {
                lb = this.labels.get(i);
            } else {
                lb = new Lbl();
                lb.listener = this.listener;
                this.labels.add(lb);
            }
            lb.update(el[i], this.c);
            ++i;
        }
        i = this.labels.size() - 1;
        while (i >= el.length) {
            lb = this.labels.get(i);
            lb.dispose();
            this.labels.remove(i);
            --i;
        }
        this.errors.getParent().update();
        this.errors.getParent().layout();
        this.c.setSize(this.c.computeSize(-1, -1));
        this.c.update();
        this.c.layout();
    }

    String[] getErrors(String s) {
        if (s == null) {
            s = "";
        }
        StringTokenizer st = new StringTokenizer(s, "\n");
        String[] rs = new String[st.countTokens()];
        int i = 0;
        while (i < rs.length) {
            rs[i] = st.nextToken();
            ++i;
        }
        return rs;
    }

    public void go() {
        if (this.labels.size() == 0) {
            return;
        }
        Lbl lb = this.labels.get(0);
        lb.go();
    }
}

