/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers.sync;

import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;

public class StrutsWebHelper {
    public static String ACTION_SERVLET = "org.apache.struts.action.ActionServlet";

    public static XModelObject findServlet(XModelObject webxml) {
        return WebAppHelper.findServlet((XModelObject)webxml, (String)ACTION_SERVLET, (String)"action");
    }

    public static XModelObject getServlet(XModelObject webxml) throws XModelException {
        return WebAppHelper.findOrCreateServlet((XModelObject)webxml, (String)ACTION_SERVLET, (String)"action", (int)-1);
    }

    public static void revalidateInitParam(XModelObject servlet, String modulename, String uri) throws XModelException {
        WebAppHelper.setWebAppInitParam((XModelObject)servlet, (String)("config" + modulename), (String)uri);
    }

    public static void revalidateInitParam(XModel model, String modulename, String uri) throws XModelException {
        XModelObject webxml = WebAppHelper.getWebApp((XModel)model);
        if (webxml == null) {
            return;
        }
        XModelObject servlet = StrutsWebHelper.getServlet(webxml);
        if (servlet != null) {
            StrutsWebHelper.revalidateInitParam(servlet, modulename, uri);
        }
    }

    public static String registerConfig(XModelObject servlet, String modulename, String uri) throws XModelException {
        XModelObject init = WebAppHelper.appendToWebAppInitParam((XModelObject)servlet, (String)("config" + modulename), (String)uri);
        return init == null ? "" : init.getAttributeValue("param-value");
    }

    public static String registerConfig(XModel model, String modulename, String uri) throws XModelException {
        XModelObject webxml = WebAppHelper.getWebApp((XModel)model);
        if (webxml == null) {
            return null;
        }
        XModelObject servlet = StrutsWebHelper.getServlet(webxml);
        return servlet != null ? StrutsWebHelper.registerConfig(servlet, modulename, uri) : null;
    }

    public static boolean isConfigRegistered(XModel model, String uri) {
        XModelObject webxml = WebAppHelper.getWebApp((XModel)model);
        if (webxml == null) {
            return false;
        }
        XModelObject servlet = WebAppHelper.findServlet((XModelObject)webxml, (String)ACTION_SERVLET, (String)"action");
        if (servlet == null) {
            return false;
        }
        XModelObject[] init = servlet.getChildren("WebAppInitParam");
        int i = 0;
        while (i < init.length) {
            String v;
            String n = init[i].getAttributeValue("param-name");
            if (n.startsWith("config") && ("," + (v = init[i].getAttributeValue("param-value")) + ",").indexOf("," + uri + ",") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void unregisterConfig(XModel model, String uri) throws XModelException {
        XModelObject webxml = WebAppHelper.getWebApp((XModel)model);
        XModelObject servlet = WebAppHelper.findServlet((XModelObject)webxml, (String)ACTION_SERVLET, (String)"action");
        if (servlet == null) {
            return;
        }
        XModelObject[] init = servlet.getChildren("WebAppInitParam");
        int i = 0;
        while (i < init.length) {
            String v;
            String vg;
            int k;
            String n = init[i].getAttributeValue("param-name");
            if (n.startsWith("config") && (k = (vg = "," + (v = init[i].getAttributeValue("param-value")) + ",").indexOf("," + uri + ",")) >= 0) {
                if ((vg = String.valueOf(vg.substring(1, k + 1)) + vg.substring(k + uri.length() + 2)).endsWith(",")) {
                    vg = vg.substring(0, vg.length() - 1);
                }
                if (vg.length() == 0) {
                    DefaultRemoveHandler.removeFromParent((XModelObject)init[i]);
                } else {
                    init[i].getModel().changeObjectAttribute(init[i], "param-value", vg);
                }
            }
            ++i;
        }
    }
}

