/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers.sync;

import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.project.WebModuleConstants;
import org.jboss.tools.struts.messages.StrutsUIMessages;

public class ModulesDataValidator
implements WebModuleConstants {
    String project;

    public void setProject(String project) {
        this.project = project;
    }

    private void setMessage(String[] errors, int i, String message) {
        if (errors[i] == null) {
            errors[i] = message;
        }
    }

    void updateErrors(XModelObject[] modules) {
        String[] errors = new String[modules.length];
        int i = 0;
        while (i < modules.length) {
            if (!"deleted".equals(modules[i].get("state"))) {
                File f;
                String path;
                String n = modules[i].getAttributeValue("name");
                String dn = this.getDisplayName(n);
                String uri = modules[i].getAttributeValue("URI");
                if (uri.length() == 0) {
                    this.setMessage(errors, i, this.getRequiredMessage("URI", dn));
                }
                if ((path = modules[i].getAttributeValue("path on disk")).length() == 0) {
                    this.setMessage(errors, i, this.getRequiredMessage("Path on Disk", dn));
                }
                if (!(f = new File(path)).isFile()) {
                    this.setMessage(errors, i, NLS.bind((String)StrutsUIMessages.PATH_IN_MODULE_MUST_REFERENCE_CONFIGFILE, (Object)dn));
                }
                if (!modules[i].getModelEntity().getName().equals("JstWebConfig")) {
                    String adn;
                    String mod = modules[i].getAttributeValue("root");
                    String string = adn = n.length() == 0 ? "Web Root" : "Module Root";
                    if (mod.length() == 0) {
                        this.setMessage(errors, i, this.getRequiredMessage(adn, dn));
                    }
                    if (this.project != null && this.project.startsWith(String.valueOf(mod.toLowerCase()) + "/")) {
                        this.setMessage(errors, i, this.getContainsProjectMessage(adn, dn));
                    }
                }
                int j = i + 1;
                while (j < modules.length) {
                    if (!"deleted".equals(modules[j].get("state"))) {
                        String path_i;
                        String uri_i = modules[j].getAttributeValue("URI");
                        if (uri.equals(uri_i)) {
                            String ms = NLS.bind((String)StrutsUIMessages.URI_ISNOT_UNIQUE, (Object)uri);
                            this.setMessage(errors, i, ms);
                            this.setMessage(errors, j, ms);
                        }
                        if ((path_i = modules[j].getAttributeValue("path on disk")).equals(path)) {
                            String ms = StrutsUIMessages.EACH_URI_MUST_REFERENCE_UNIQUE_PATH;
                            this.setMessage(errors, i, ms);
                            this.setMessage(errors, j, ms);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < modules.length) {
            modules[i].setObject("error", (Object)errors[i]);
            ++i;
        }
    }

    public String getErrorMessage(XModelObject[] modules, XModelObject selected) {
        if (this.project != null) {
            this.project = this.project.toLowerCase().replace('\\', '/');
        }
        this.updateErrors(modules);
        if (selected != null && selected.getObject("error") != null) {
            return selected.getObject("error").toString();
        }
        int i = 0;
        while (i < modules.length) {
            if (modules[i].getObject("error") != null) {
                return modules[i].getObject("error").toString();
            }
            ++i;
        }
        return null;
    }

    private String getRequiredMessage(String attr, String module) {
        return NLS.bind((String)StrutsUIMessages.ATTRIBUTE_FOR_MODULE_MUST_BE_SET, (Object)attr, (Object)module);
    }

    private String getContainsProjectMessage(String attr, String module) {
        return NLS.bind((String)StrutsUIMessages.ATTRIBUTE_OF_MODULE_CANNOT_REFERENCE_FOLDER, (Object)attr, (Object)module);
    }

    private String getDisplayName(String name) {
        return name.length() == 0 ? "<default>" : name;
    }
}

