/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.plugins.model.handlers;

import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class AddSpecialPluginHandler
extends AbstractHandler {
    public boolean isEnabled(XModelObject object) {
        boolean b = this.validateActionName();
        if (object == null || !object.isObjectEditable()) {
            return false;
        }
        return b;
    }

    boolean validateActionName() {
        XModelObject plugin = this.getPlugin(PreferenceModelUtilities.getPreferenceModel());
        String dn = null;
        if (plugin != null) {
            dn = plugin.getAttributeValue("title");
            if (dn == null) {
                dn = plugin.getAttributeValue("name");
            }
        } else {
            dn = StrutsUIMessages.ADD_PLUGIN_BY_TEMPLATE;
        }
        ((XActionImpl)this.action).setDisplayName(dn);
        return plugin != null;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        XModelObject plugin = this.getPlugin(PreferenceModelUtilities.getPreferenceModel());
        if (plugin == null) {
            return;
        }
        String text = plugin.getAttributeValue("text");
        Element e = this.getElement(plugin.getAttributeValue("text"));
        if (e == null) {
            this.fireErrors(object.getModel(), text, plugin.getAttributeValue("title"));
            return;
        }
        plugin = this.loadPlugin(object.getModel(), e);
        XModelObject old = this.findPlugin(object, plugin);
        if (old != null) {
            ServiceDialog d = object.getModel().getService();
            String mes = NLS.bind((String)StrutsUIMessages.PLUGIN_FOR_CLASS_EXISTS, (Object)plugin.getAttributeValue("className"));
            int q = d.showDialog(StrutsUIMessages.ADD_PLUGIN, mes, new String[]{StrutsUIMessages.OK, StrutsUIMessages.CANCEL}, null, 0);
            if (q != 0) {
                return;
            }
            DefaultRemoveHandler.removeFromParent((XModelObject)old);
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)object, (XModelObject)plugin, (Properties)p);
    }

    private XModelObject getPlugin(XModel model) {
        if (this.action == null) {
            return null;
        }
        String v = this.action.getProperty("index");
        if (v == null || v.length() == 0) {
            return null;
        }
        int i = -1;
        try {
            i = Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (i < 0) {
            return null;
        }
        XModelObject[] ps = model.getByPath("%Options%/Struts Studio/Automation/Plug-ins Insets").getChildren();
        return i < ps.length ? ps[i] : null;
    }

    private Element getElement(String text) {
        StringReader sr = new StringReader(text);
        return XMLUtil.getElement((Reader)sr);
    }

    private void fireErrors(XModel model, String text, String title) {
        String[] s = AddSpecialPluginHandler.getXMLErrors(new StringReader(text));
        if (s.length == 0) {
            return;
        }
        ServiceDialog d = model.getService();
        d.showDialog("", NLS.bind((String)StrutsUIMessages.WRONG_TEXT_IN_PLUGIN_OPTION, (Object)title, (Object)s[0]), new String[]{StrutsUIMessages.OK}, null, 1);
    }

    private XModelObject loadPlugin(XModel model, Element e) {
        XModelObject plugin = model.createModelObject("StrutsPlugin11", null);
        XModelObjectLoaderUtil util = new XModelObjectLoaderUtil();
        util.loadAttributes(e, plugin);
        util.loadChildren(e, plugin);
        return plugin;
    }

    private XModelObject findPlugin(XModelObject parent, XModelObject plugin) {
        String cn = plugin.getAttributeValue("className");
        XModelObject[] ps = parent.getChildren();
        int i = 0;
        while (i < ps.length) {
            if (cn.equals(ps[i].getAttributeValue("className"))) {
                return ps[i];
            }
            ++i;
        }
        return null;
    }

    private static String[] getXMLErrors(Reader reader) {
        try {
            InputSource inSource = new InputSource(reader);
            return AddSpecialPluginHandler.getXMLErrors(inSource);
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
            return new String[]{e.getMessage()};
        }
    }

    private static String[] getXMLErrors(InputSource is) {
        return XMLUtilities.getXMLErrors((InputSource)is, (boolean)false, (EntityResolver)XMLEntityResolver.getInstance());
    }
}

