/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.pv;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.struts.model.pv.StrutsProjectResourceBundles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsProjectTagLibs
extends StrutsProjectResourceBundles {
    private static final long serialVersionUID = 562611058980338342L;
    static String TLD_ENTITIES = ".FileTLD_PRO.FileTLD_1_2.FileTLD_2_0.FileTLD_2_1.";

    @Override
    protected Iterator<XModelObject> getRoots() {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject r = FileSystemsHelper.getWebInf((XModel)this.getModel());
        if (r != null) {
            list.add(r);
        }
        if ((r = this.getModel().getByPath("FileSystems/lib-struts.jar/META-INF")) != null) {
            list.add(r);
        }
        return list.iterator();
    }

    @Override
    protected List<XModelObject> collect(Iterator<XModelObject> rs) {
        List<XModelObject> list = super.collect(rs);
        Iterator<XModelObject> it = list.iterator();
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            XModelObject o = it.next();
            String uri = o.getAttributeValue("uri");
            if (set.contains(uri)) {
                it.remove();
                continue;
            }
            set.add(uri);
        }
        return list;
    }

    @Override
    protected boolean acceptFile(XModelObject o) {
        return StrutsProjectTagLibs.isTLDFile(o);
    }

    public static boolean isTLDFile(XModelObject o) {
        String entity = "." + o.getModelEntity().getName();
        return TLD_ENTITIES.indexOf(entity) >= 0;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            XModelObject o = FileSystemsHelper.getWebInf((XModel)this.getModel());
            return o != null ? o.getAdapter(adapter) : null;
        }
        return super.getAdapter(adapter);
    }
}

