/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.trees.DefaultSiftedTree;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class ActionsTree
extends DefaultSiftedTree
implements StrutsConstants {
    protected XModelObject thisConfig = null;
    protected Map<String, XModelObject> configs = new TreeMap<String, XModelObject>();
    protected Map<XModelObject, XModelObject[]> allconfigs = new HashMap<XModelObject, XModelObject[]>();
    protected Map<String, String> modules = new TreeMap<String, String>();
    protected WebModulesHelper helper = null;
    protected XModelObject root;
    protected boolean isThis = false;
    protected UrlPattern up;

    public void dispose() {
        if (this.configs != null) {
            this.configs.clear();
        }
        this.configs = null;
        if (this.allconfigs != null) {
            this.allconfigs.clear();
        }
        this.allconfigs = null;
        if (this.modules != null) {
            this.modules.clear();
        }
        this.modules = null;
    }

    public void setConstraint(Object object) {
        int i;
        String s;
        if (object instanceof Boolean) {
            this.isThis = (Boolean)object;
            return;
        }
        XModel model = ((XModelObject)object).getModel();
        this.thisConfig = StrutsProcessStructureHelper.instance.getParentFile((XModelObject)object);
        this.up = StrutsProcessStructureHelper.instance.getUrlPattern((XModelObject)object);
        if (this.thisConfig != null && !this.thisConfig.getModelEntity().getName().startsWith("StrutsConfig")) {
            this.thisConfig = null;
        }
        this.configs.clear();
        this.allconfigs.clear();
        this.modules.clear();
        this.root = FileSystemsHelper.getFileSystems((XModel)model);
        this.helper = WebModulesHelper.getInstance(model);
        String string = s = this.thisConfig == null ? "" : this.helper.getModuleForConfig(this.thisConfig);
        if (s == null) {
            s = "";
        }
        if (this.thisConfig != null) {
            XModelObject[] cgs = this.helper.getConfigsForModule(this.thisConfig.getModel(), s);
            if (cgs.length == 0) {
                cgs = new XModelObject[]{this.thisConfig};
            }
            this.configs.put(s, this.thisConfig);
            if (cgs.length > 1) {
                this.allconfigs.put(this.thisConfig, cgs);
            }
            i = 0;
            while (i < cgs.length) {
                this.modules.put(cgs[i].getPath(), s);
                ++i;
            }
        }
        if (this.isThis) {
            return;
        }
        XModelObject[] ms = model.getByPath("Web").getChildren();
        i = 0;
        while (i < ms.length) {
            XModelObject cg = model.getByPath(ms[i].getAttributeValue("model path"));
            if (cg != null && cg != this.thisConfig) {
                s = this.helper.getModuleForConfig(cg);
                if (s == null) {
                    s = "";
                }
                if (!this.configs.containsKey(s)) {
                    XModelObject[] cgs = this.helper.getConfigsForModule(cg.getModel(), s);
                    if (cgs.length == 0) {
                        cgs = new XModelObject[]{cg};
                    }
                    this.configs.put(s, cg);
                    if (cgs.length > 1) {
                        this.allconfigs.put(cg, cgs);
                    }
                    int j = 0;
                    while (j < cgs.length) {
                        this.modules.put(cgs[j].getPath(), s);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public XModelObject getRoot() {
        return this.isThis ? this.thisConfig : this.root;
    }

    public boolean hasChildren(XModelObject object) {
        if (object == null || !object.isActive()) {
            return false;
        }
        return object == this.root || this.modules.containsKey(object.getPath());
    }

    public XModelObject[] getChildren(XModelObject object) {
        if (!this.hasChildren(object)) {
            return new XModelObject[0];
        }
        if (object == this.root) {
            return this.configs.values().toArray(new XModelObject[0]);
        }
        XModelObject am = object.getChildByPath("action-mappings");
        if (am == null) {
            return new XModelObject[0];
        }
        XModelObject[] cgs = this.allconfigs.get(object);
        if (cgs == null) {
            return am == null ? new XModelObject[]{} : am.getChildren();
        }
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        int i = 0;
        while (i < cgs.length) {
            am = cgs[i].getChildByPath("action-mappings");
            if (am != null) {
                XModelObject[] cs = am.getChildren();
                int j = 0;
                while (j < cs.length) {
                    list.add(cs[j]);
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }

    public String getPath(XModelObject o) {
        if (this.hasChildren(o)) {
            return "";
        }
        String p = o.getAttributeValue("path");
        boolean slash = p.startsWith("/");
        p = this.up.getActionUrl(p);
        if (!slash && p.startsWith("/")) {
            p = p.substring(1);
        }
        String path = p;
        if (!o.isActive()) {
            return path;
        }
        XModelObject mp = o.getParent().getParent();
        if (mp == this.thisConfig) {
            return path;
        }
        String module = this.modules.get(mp.getPath());
        if (module == null) {
            module = "";
        }
        return this.up.getContextRelativePath(path, module);
    }

    public String getPresentation(XModelObject o) {
        if (o == this.root) {
            return "Modules";
        }
        String module = this.modules.get(o.getPath());
        if (module != null) {
            return module.length() == 0 ? "<default>" : module;
        }
        return o.getPresentationString();
    }

    public String getModule(XModelObject selectedAction) {
        if (!selectedAction.isActive()) {
            return "";
        }
        return this.modules.get(selectedAction.getParent().getParent().getPath());
    }

    public XModelObject find(String path) {
        XModelObject a;
        int i;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String pathmodule = (i = (path = this.up.getActionPath(path)).indexOf("/", 1)) < 0 ? "" : path.substring(0, i);
        path = path.replace('/', '#');
        if (pathmodule.length() > 0 && (a = this.findInModule(pathmodule, path.substring(i), false)) != null) {
            return a;
        }
        XModelObject xModelObject = a = this.thisConfig == null ? null : this.findInConfig(this.thisConfig, path);
        if (a != null) {
            return a;
        }
        a = this.findInModule("", path, true);
        return a;
    }

    private XModelObject findInModule(String pathmodule, String path, boolean notThis) {
        XModelObject cg = this.configs.get(pathmodule);
        if (cg == null) {
            return null;
        }
        if (notThis && cg == this.thisConfig) {
            return null;
        }
        return this.findInConfig(cg, path);
    }

    private XModelObject findInConfig(XModelObject cg, String path) {
        if (cg == null) {
            return null;
        }
        XModelObject c = cg.getChildByPath("action-mappings/" + path);
        if (c != null) {
            return c;
        }
        XModelObject[] cgs = this.allconfigs.get(cg);
        if (cgs == null) {
            return null;
        }
        int i = 0;
        while (i < cgs.length) {
            c = cgs[i].getChildByPath("action-mappings/" + path);
            if (c != null) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public XModelObject getParent(XModelObject object) {
        if (object == null) {
            return null;
        }
        String entity = object.getModelEntity().getName();
        if (entity.startsWith("StrutsAction") && object.isActive()) {
            XModelObject pcg = object.getParent().getParent();
            String path = pcg.getPath();
            String module = this.modules.get(path);
            if (module == null) {
                return pcg;
            }
            XModelObject mcg = this.configs.get(module);
            return mcg != null ? mcg : pcg;
        }
        if (!this.isThis && entity.startsWith("StrutsConfig")) {
            return this.root;
        }
        return object.getParent();
    }
}

