/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesHelper {
    static String PLUGIN = "org.apache.struts.tiles.TilesPlugin";
    static String CONFIG = "definitions-config";

    public static Map<String, XModelObject> getTiles(XModelObject object) {
        XModelObject o = StrutsProcessStructureHelper.instance.getParentFile(object);
        if (o == null || o.getModelEntity().getName().endsWith("10") || !o.getModelEntity().getName().startsWith("StrutsConfig")) {
            return new TreeMap<String, XModelObject>();
        }
        WebModulesHelper h = WebModulesHelper.getInstance(object.getModel());
        String module = h.getModuleForConfig(o);
        XModelObject[] cs = h.getConfigsForModule(object.getModel(), module);
        if (cs.length < 2) {
            return TilesHelper.getDefinitions(TilesHelper.getDefinitionsConfig(TilesHelper.getTilesPlugin(o)));
        }
        Map<String, XModelObject> map = TilesHelper.getDefinitions(TilesHelper.getDefinitionsConfig(TilesHelper.getTilesPlugin(cs[0])));
        int i = 1;
        while (i < cs.length) {
            map.putAll(TilesHelper.getDefinitions(TilesHelper.getDefinitionsConfig(TilesHelper.getTilesPlugin(cs[i]))));
            ++i;
        }
        return map;
    }

    public static XModelObject findTile(XModelObject object, String name) {
        XModelObject o = StrutsProcessStructureHelper.instance.getParentFile(object);
        if (o == null || o.getModelEntity().getName().endsWith("10")) {
            return null;
        }
        XModelObject dc = TilesHelper.getDefinitionsConfig(TilesHelper.getTilesPlugin(o));
        XModelObject t = TilesHelper.findTileByDefinitionConfig(dc, name);
        if (t != null) {
            return t;
        }
        WebModulesHelper h = WebModulesHelper.getInstance(object.getModel());
        String module = h.getModuleForConfig(o);
        XModelObject[] cs = h.getConfigsForModule(object.getModel(), module);
        if (cs.length < 2) {
            return null;
        }
        int i = 0;
        while (i < cs.length) {
            if (cs[i] != o && (t = TilesHelper.findTileByDefinitionConfig(dc = TilesHelper.getDefinitionsConfig(TilesHelper.getTilesPlugin(cs[i])), name)) != null) {
                return t;
            }
            ++i;
        }
        return null;
    }

    static XModelObject getTilesPlugin(XModelObject strutsconfig) {
        XModelObject f = strutsconfig.getChildByPath("plug-ins");
        if (f == null) {
            return null;
        }
        XModelObject[] ps = f.getChildren();
        int i = 0;
        while (i < ps.length) {
            if (PLUGIN.equals(ps[i].getAttributeValue("className"))) {
                return ps[i];
            }
            ++i;
        }
        return null;
    }

    static XModelObject getDefinitionsConfig(XModelObject plugin) {
        if (plugin == null) {
            return null;
        }
        XModelObject[] ps = plugin.getChildren();
        int i = 0;
        while (i < ps.length) {
            if (CONFIG.equals(ps[i].getAttributeValue("property"))) {
                return ps[i];
            }
            ++i;
        }
        return null;
    }

    private static Map<String, XModelObject> getDefinitions(XModelObject cg) {
        String[] fs = TilesHelper.getTileFileNames(cg);
        TreeMap<String, XModelObject> set = new TreeMap<String, XModelObject>();
        if (cg != null) {
            int i = 0;
            while (i < fs.length) {
                XModelObject tilesdef = TilesHelper.findTilesFile(cg.getModel(), fs[i]);
                if (tilesdef != null) {
                    XModelObject[] ds = tilesdef.getChildren();
                    int j = 0;
                    while (j < ds.length) {
                        set.put(ds[j].getPathPart(), ds[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return set;
    }

    private static XModelObject findTileByDefinitionConfig(XModelObject cg, String name) {
        String[] fs = TilesHelper.getTileFileNames(cg);
        if (cg != null) {
            int i = 0;
            while (i < fs.length) {
                XModelObject c;
                XModelObject tilesdef = TilesHelper.findTilesFile(cg.getModel(), fs[i]);
                if (tilesdef != null && (c = tilesdef.getChildByPath(name)) != null) {
                    return c;
                }
                ++i;
            }
        }
        return null;
    }

    static String[] getTileFileNames(XModelObject cg) {
        if (cg == null) {
            return new String[0];
        }
        String value = cg.getAttributeValue("value");
        if (value == null || value.length() == 0) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        String[] ns = new String[st.countTokens()];
        int i = 0;
        while (i < ns.length) {
            ns[i] = st.nextToken().trim();
            ++i;
        }
        return ns;
    }

    static XModelObject findTilesFile(XModel model, String path) {
        if (path.length() == 0) {
            return null;
        }
        XModelObject o = model.getByPath("FileSystems" + path);
        if (o != null) {
            return o;
        }
        return XModelImpl.getByRelativePath((XModel)model, (String)path);
    }
}

