/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.handlers.StrutsCopyHandler;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.page.ReplaceConfirmedLinkHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class StrutsLinkHelper
implements StrutsConstants {
    private static final int U_K = -1;
    private static final int CONFIG = 0;
    private static final int ACTION = 1;
    private static final int FORWARD = 2;
    private static final int EXCEPTION = 3;
    private static final int PAGE = 4;
    private static final int LINK = 5;
    private static final int LINK_C = 6;
    private static final int ACTION_U = 7;
    private static final int ACTION_F = 8;
    private static final int ACTION_I = 9;
    private static final int ACTION_A = 10;
    private static final int ACTION_S = 11;
    private static final int S_P = 0;
    private static final int S_T = 1;
    private static final int C_F = 2;
    private static final int C_L = 3;
    private static final int S_F = 4;
    private static final int S_I = 5;
    private static final int R_L = 6;
    private static final int R_P = 7;
    private static final int S_M = 8;
    private static final int[][] LINK_TYPES;

    static {
        int[][] nArrayArray = new int[5][];
        nArrayArray[0] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        int[] nArray = new int[12];
        nArray[0] = -1;
        nArray[1] = 2;
        nArray[4] = 3;
        nArray[5] = 6;
        nArray[6] = 7;
        nArray[7] = -1;
        nArray[8] = 4;
        nArray[9] = 5;
        nArray[10] = 8;
        nArray[11] = -1;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{-1, -1, -1, -1, 3, -1, 7, -1, -1, -1, -1, -1};
        nArrayArray[3] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        int[] nArray2 = new int[12];
        nArray2[0] = -1;
        nArray2[1] = 2;
        nArray2[4] = 3;
        nArray2[5] = 6;
        nArray2[6] = 7;
        nArray2[7] = -1;
        nArray2[8] = 4;
        nArray2[9] = 5;
        nArray2[10] = 8;
        nArray2[11] = -1;
        nArrayArray[4] = nArray2;
        LINK_TYPES = nArrayArray;
    }

    public boolean canLink(XModelObject target, XModelObject object) {
        if (target == null || object == null) {
            return false;
        }
        XModelObject config = this.getConfig(target, object);
        if (config == null) {
            return false;
        }
        int objectType = this.getObjectType(object, true);
        int targetType = this.getObjectType(target, false);
        if (objectType == -1 || targetType == -1) {
            return false;
        }
        return LINK_TYPES[targetType][objectType] != -1;
    }

    public void link(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (target == null || object == null) {
            return;
        }
        XModelObject config = this.getConfig(target, object);
        if (config == null) {
            return;
        }
        WebModulesHelper wmh = WebModulesHelper.getInstance(config.getModel());
        String module = wmh.getModuleForConfig(config);
        UrlPattern urlPattern = wmh.getUrlPattern(module);
        int objectType = this.getObjectType(object, true);
        int targetType = this.getObjectType(target, false);
        if (objectType == -1 || targetType == -1) {
            return;
        }
        int linkType = LINK_TYPES[targetType][objectType];
        if (linkType == -1) {
            return;
        }
        String name = p.getProperty("originalTarget", target.getAttributeValue("name"));
        String path = target.getAttributeValue("path");
        if (targetType == 1 || targetType >= 7) {
            path = urlPattern.getActionUrl(path);
        }
        if (targetType == 2) {
            path = this.getForwardName(target);
        }
        switch (linkType) {
            case 0: {
                if (objectType == 2) {
                    path = StrutsProcessStructureHelper.instance.getValidForwardPath(object, path);
                }
                this.redirect(object, null, path);
                break;
            }
            case 1: {
                this.redirect(object, name, path);
                break;
            }
            case 2: {
                this.createForward(object, path);
                break;
            }
            case 3: {
                this.createLink(object, name, path);
                break;
            }
            case 4: {
                object.getModel().changeObjectAttribute(object, "forward", path);
                break;
            }
            case 8: {
                object.getModel().changeObjectAttribute(object, "parameter", path);
                break;
            }
            case 5: {
                object.getModel().changeObjectAttribute(object, "include", path);
                break;
            }
            case 6: {
                if (this.findDuplicateLink(object.getParent(), name, path) != null) {
                    return;
                }
                this.redirect(object, name, path);
                break;
            }
            case 7: {
                if (this.findDuplicateLink(object.getParent(), name, path) != null) {
                    return;
                }
                if ("page".equals(object.getParent().getAttributeValue("type"))) {
                    String attr = null;
                    if (targetType == 2) {
                        attr = "forward";
                    } else if (urlPattern.isActionUrl(path)) {
                        attr = "action";
                    }
                    this.redirect_link(object, name, path, attr);
                    break;
                }
                this.redirect(object, name, path);
            }
        }
    }

    private void redirect_link(XModelObject object, String target, String path, String attr) throws XModelException {
        XUndoManager undo = object.getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo("redirect " + DefaultCreateHandler.title((XModelObject)object, (boolean)false), 0);
        undo.addUndoable((XUndoable)u);
        long stamp = object.getTimeStamp();
        try {
            boolean isForward = "forward".equals(attr);
            if (!new ReplaceConfirmedLinkHelper().replace(object, path, attr)) {
                undo.rollbackTransactionInProgress();
                return;
            }
            try {
                if (target != null) {
                    object.getModel().changeObjectAttribute(object, "target", target);
                }
                object.getModel().changeObjectAttribute(object, "path", isForward ? "" : path);
                String linkShapeAttr = object.getAttributeValue("link shape") != null ? "link shape" : "shape";
                object.getModel().changeObjectAttribute(object, linkShapeAttr, "");
                if (stamp == object.getTimeStamp()) {
                    undo.rollbackTransactionInProgress();
                }
            }
            catch (RuntimeException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    private void redirect(XModelObject object, String target, String path) throws XModelException {
        XUndoManager undo = object.getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo("redirect " + DefaultCreateHandler.title((XModelObject)object, (boolean)false), 0);
        undo.addUndoable((XUndoable)u);
        long stamp = object.getTimeStamp();
        try {
            try {
                XModelObject r;
                String rp = StrutsCopyHandler.referentBuffer;
                if (rp != null && (r = object.getModel().getByPath(rp)) != null) {
                    String linkShapeAttr = r.getAttributeValue("link shape") != null ? "link shape" : "shape";
                    object.getModel().changeObjectAttribute(r, linkShapeAttr, "");
                }
                if (target != null) {
                    object.getModel().changeObjectAttribute(object, "target", target);
                }
                object.getModel().changeObjectAttribute(object, "path", path);
                if (stamp == object.getTimeStamp()) {
                    undo.rollbackTransactionInProgress();
                }
            }
            catch (RuntimeException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    private XModelObject createLink(XModelObject page, String target, String path) throws XModelException {
        XModelObject link = this.findDuplicateLink(page, target, path);
        if (link != null) {
            return link;
        }
        String name = StrutsProcessHelper.createName(page, "link");
        String title = path;
        if (title.length() > 0) {
            if (title.charAt(title.length() - 1) == '/') {
                title = title.substring(0, title.length() - 1);
            }
            title = title.substring(title.lastIndexOf(47) + 1);
        }
        Properties props = new Properties();
        props.setProperty("name", name);
        props.setProperty("type", "link");
        props.setProperty("path", path);
        props.setProperty("target", target);
        props.setProperty("title", title);
        link = XModelObjectLoaderUtil.createValidObject((XModel)page.getModel(), (String)"StrutsProcessItemOutput", (Properties)props);
        DefaultCreateHandler.addCreatedObject((XModelObject)page, (XModelObject)link, (int)-1);
        return link;
    }

    private XModelObject createForward(XModelObject action, String path) throws XModelException {
        String name = path.substring(path.lastIndexOf(47) + 1);
        int dot = name.indexOf(46);
        if (dot != -1) {
            name = name.substring(0, dot);
        }
        if (name.length() > 1 && Character.isLowerCase(name.charAt(1))) {
            name = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
        } else if (name.length() == 0) {
            name = "forward";
        }
        if (action.getChildByPath(name) != null) {
            int ind = 2;
            while (action.getChildByPath(String.valueOf(name) + ind) != null) {
                ++ind;
            }
            name = String.valueOf(name) + ind;
        }
        String actionEntity = action.getModelEntity().getName();
        String entity = "StrutsForward" + actionEntity.substring(actionEntity.length() - 2);
        Properties props = new Properties();
        props.setProperty("name", name);
        props.setProperty("path", path);
        XModelObject forward = XModelObjectLoaderUtil.createValidObject((XModel)action.getModel(), (String)entity, (Properties)props);
        DefaultCreateHandler.addCreatedObject((XModelObject)action, (XModelObject)forward, (int)-1);
        return forward;
    }

    private int getObjectType(XModelObject object, boolean source) {
        String entity = object.getModelEntity().getName();
        if (entity.startsWith("StrutsForward")) {
            if (!source && !object.getParent().getModelEntity().getName().startsWith("StrutsGlobalForwards")) {
                return 0;
            }
            return 2;
        }
        if (entity.startsWith("StrutsAction")) {
            if (!source) {
                return 1;
            }
            String jtype = object.getAttributeValue("type");
            if ("org.apache.struts.actions.SwitchAction".equals(jtype)) {
                return 11;
            }
            if ("org.apache.struts.actions.ForwardAction".equals(jtype)) {
                return 10;
            }
            if (object.getAttributeValue("forward").length() > 0) {
                return 8;
            }
            if (object.getAttributeValue("include").length() > 0) {
                return 9;
            }
            return 1;
        }
        if (entity.startsWith("StrutsException")) {
            return 3;
        }
        if (entity.startsWith("StrutsProcessItem")) {
            String type = object.getAttributeValue("type");
            if ("action".equals(type)) {
                if (!source) {
                    return 1;
                }
                String subtype = object.getAttributeValue("subtype");
                if ("forward".equals(subtype)) {
                    return 8;
                }
                if ("include".equals(subtype)) {
                    return 9;
                }
                if ("unknown".equals(subtype)) {
                    return 7;
                }
                if ("parameter".equals(subtype)) {
                    return 10;
                }
                if ("switch".equals(subtype)) {
                    return 11;
                }
                return 1;
            }
            if ("page".equals(type)) {
                return 4;
            }
            if ("link".equals(type)) {
                if (!source) {
                    return 0;
                }
                String subtype = object.getAttributeValue("subtype");
                return subtype.length() == 0 ? 5 : 6;
            }
            if ("forward".equals(type)) {
                if (!source && !object.getModelEntity().getName().equals("StrutsItemOutput")) {
                    return 0;
                }
                return 2;
            }
            if ("exception".equals(type)) {
                return 3;
            }
            return -1;
        }
        if (entity.startsWith("StrutsConfig")) {
            return 0;
        }
        return -1;
    }

    private XModelObject getConfig(XModelObject target, XModelObject object) {
        XModelObject config = target;
        while (!config.getModelEntity().getName().startsWith("StrutsConfig")) {
            if ((config = config.getParent()) != null) continue;
            return null;
        }
        while (object != config) {
            if ((object = object.getParent()) != null) continue;
            return null;
        }
        return config;
    }

    private XModelObject findDuplicateLink(XModelObject object, String target, String path) throws XModelException {
        if (!"page".equals(object.getAttributeValue("type"))) {
            return null;
        }
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (target.equals(cs[i].getAttributeValue("target"))) {
                if ("yes".equals(cs[i].getAttributeValue("shortcut")) || "yes".equals(cs[i].getAttributeValue("hidden"))) {
                    cs[i].getModel().changeObjectAttribute(cs[i], "shortcut", "no");
                    cs[i].getModel().changeObjectAttribute(cs[i], "hidden", "no");
                    return cs[i];
                }
                ServiceDialog d = object.getModel().getService();
                String mes = NLS.bind((String)StrutsUIMessages.PAGE_CONTAINS_LINK, (Object)object.getAttributeValue("title"), (Object)path);
                d.showDialog(StrutsUIMessages.ERROR, mes, new String[]{StrutsUIMessages.OK}, null, 1);
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    private String getForwardName(XModelObject target) {
        if (target instanceof ReferenceObjectImpl) {
            target = ((ReferenceObjectImpl)target).getReference();
        }
        return target.getAttributeValue("name");
    }
}

