/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.model.handlers.SelectOnDiagramHandler;

public class StrutsBreakpointManager
implements IBreakpointListener {
    public static final int STATUS_NO_BREAKPOINT = 1;
    public static final int STATUS_BREAKPOINT_DISABLED = 2;
    public static final int STATUS_BREAKPOINT_ENABLED = 4;
    public static final int STATUS_BREAKPOINT_ACTIVE = 8;
    public static final String MODEL_BREAKPOINT = "org.jboss.tools.common.model.modelBreakpointMarker";
    public static final String ATTR_MODEL_PATH = "org.jboss.tools.common.model.debug.modelPath";
    private XModelObject process = null;
    private StatusMap statusMap = new StatusMap();
    IBreakpointListener listener = null;

    public StrutsBreakpointManager(XModelObject process) {
        this.process = process;
    }

    public void activate() {
        if (this.listener != null) {
            return;
        }
        this.listener = this;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener(this.listener);
        this.update();
    }

    public void deactivate() {
        if (this.listener == null) {
            return;
        }
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.listener = null;
    }

    private boolean isValid() {
        if (this.process == null) {
            return false;
        }
        if (!this.process.isActive()) {
            this.deactivate();
            return false;
        }
        return true;
    }

    public int getBreakpointStatus(XModelObject object) {
        return this.statusMap.getSummaryBreakpointStatus(object.getPath());
    }

    public int getBreakpointStatus(XModelObject object, String markerType) {
        return this.statusMap.getBreakpointStatus(object.getPath(), markerType);
    }

    public int getActiveBreakpointNumber(XModelObject object) {
        return this.statusMap.getActiveBreakpointNumber(object.getPath());
    }

    public void update() {
        IMarker[] markers;
        IResource file = this.getProcessResource();
        if (file == null || !file.exists()) {
            return;
        }
        try {
            markers = file.findMarkers(MODEL_BREAKPOINT, true, 2);
        }
        catch (CoreException ex) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)ex);
            return;
        }
        StatusMap newStatusMap = new StatusMap();
        int i = 0;
        while (i < markers.length) {
            IBreakpoint breakpoint;
            String modelPath = markers[i].getAttribute(ATTR_MODEL_PATH, null);
            if (modelPath != null && (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(markers[i])) != null) {
                try {
                    newStatusMap.changeBreakpointStatus(modelPath, markers[i].getType(), breakpoint.isEnabled() ? 4 : 2);
                }
                catch (CoreException e) {
                    StrutsModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ++i;
        }
        BreakpointId[] oldKeys = this.statusMap.getBreakpointIds();
        int i2 = 0;
        while (i2 < oldKeys.length) {
            if (!newStatusMap.containsKey(oldKeys[i2])) {
                this.fireBreakpointStatusChanged(this.process.getModel().getByPath(oldKeys[i2].getModelPath()), oldKeys[i2].getMarkerType(), 1);
            }
            ++i2;
        }
        BreakpointId[] newKeys = newStatusMap.getBreakpointIds();
        int i3 = 0;
        while (i3 < newKeys.length) {
            XModelObject object;
            int newStatus = newStatusMap.getBreakpointStatus(newKeys[i3]);
            if (newStatus != this.statusMap.getBreakpointStatus(newKeys[i3]) && (object = this.process.getModel().getByPath(newKeys[i3].getModelPath())) != null) {
                this.fireBreakpointStatusChanged(object, newKeys[i3].getMarkerType(), newStatus);
            }
            ++i3;
        }
        this.statusMap = newStatusMap;
    }

    public boolean isDebugMode() {
        return false;
    }

    public void fireBreakpointStatusChanged(XModelObject object, String markerType, int newStatus, boolean mergeStatuses) {
        if (object != null) {
            String modelPath = object.getPath();
            if (markerType == null) {
                this.statusMap.changeAllBreakpointStatus(modelPath, newStatus, mergeStatuses);
            } else {
                this.statusMap.changeBreakpointStatus(modelPath, markerType, newStatus, mergeStatuses);
            }
            XModelObjectImpl diagramObject = null;
            String entity = object.getModelEntity().getName();
            diagramObject = "StrutsProcessItem".equals(entity) || "StrutsProcessItemOutput".equals(entity) ? (XModelObjectImpl)object : (XModelObjectImpl)SelectOnDiagramHandler.getItemOnProcess(object);
            if (diagramObject != null) {
                new DiagramChangeHandler(diagramObject, newStatus).start();
            }
        }
    }

    public void fireBreakpointStatusChanged(XModelObject object, String markerType, int newStatus) {
        this.fireBreakpointStatusChanged(object, markerType, newStatus, false);
    }

    public void fireAllBreakpointStatusChanged(int newStatus, boolean mergeStatuses) {
        this.statusMap.changeAllBreakpointStatus(newStatus, mergeStatuses);
    }

    public void fireAllBreakpointStatusChanged(XModelObject object, int newStatus) {
        this.fireBreakpointStatusChanged(object, null, newStatus);
    }

    private IResource getProcessResource() {
        return EclipseResourceUtil.getResource((XModelObject)this.process);
    }

    private void doBreakpointChanged(IBreakpoint breakpoint, int newStatus) {
        if (!this.isValid()) {
            return;
        }
        IMarker marker = breakpoint.getMarker();
        XModelObject object = this.getXMO(breakpoint);
        try {
            if (object != null && marker.isSubtypeOf(MODEL_BREAKPOINT)) {
                this.fireBreakpointStatusChanged(object, marker.getType(), newStatus);
            }
        }
        catch (CoreException e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.doBreakpointChanged(breakpoint, 4);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.doBreakpointChanged(breakpoint, 1);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.isValid()) {
            return;
        }
        try {
            XModelObject object = this.getXMO(breakpoint);
            if (object != null) {
                String markerType = null;
                if (delta != null) {
                    markerType = delta.getMarker().getType();
                }
                int status = this.getBreakpointStatus(object, markerType);
                int newStatus = breakpoint.isEnabled() ? 4 | status & 8 : 2 | status & 8;
                this.doBreakpointChanged(breakpoint, newStatus);
            }
        }
        catch (CoreException e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private XModelObject getXMO(IBreakpoint breakpoint) {
        IResource processResource = this.getProcessResource();
        if (processResource.equals((Object)breakpoint.getMarker().getResource())) {
            IMarker marker = breakpoint.getMarker();
            try {
                if (marker.isSubtypeOf(MODEL_BREAKPOINT)) {
                    XModelObject object = EclipseResourceUtil.getObjectByPath((IProject)processResource.getProject(), (String)marker.getAttribute(ATTR_MODEL_PATH, null));
                    return object;
                }
            }
            catch (CoreException e) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public XModelObject[] findObjectByStatus(int breakpointStatus) {
        ArrayList<XModelObject> result = new ArrayList<XModelObject>();
        BreakpointId[] keys = this.statusMap.getBreakpointIds();
        int i = 0;
        while (i < keys.length) {
            XModelObject xObject;
            String modelPath = keys[i].getModelPath();
            if ((this.statusMap.getSummaryBreakpointStatus(modelPath) & breakpointStatus) != 0 && (xObject = this.process.getModel().getByPath(modelPath)) != null) {
                result.add(xObject);
            }
            ++i;
        }
        return result.size() > 0 ? result.toArray(new XModelObject[result.size()]) : null;
    }

    public String[] getMarkerTypesByStatus(XModelObject object, int status) {
        ArrayList<String> types = new ArrayList<String>();
        if (object != null) {
            String modelPath = object.getPath();
            BreakpointId[] brIds = this.statusMap.getBreakpointIds();
            int i = 0;
            while (i < brIds.length) {
                if (modelPath.equals(brIds[i].getModelPath()) && status == this.statusMap.getBreakpointStatus(brIds[i])) {
                    types.add(brIds[i].getMarkerType());
                }
                ++i;
            }
        }
        return types.toArray(new String[types.size()]);
    }

    private static class BreakpointId {
        private String modelPath;
        private String markerType;

        public BreakpointId(String modelPath, String markerType) {
            this.modelPath = modelPath;
            this.markerType = markerType;
        }

        public String getMarkerType() {
            return this.markerType;
        }

        public String getModelPath() {
            return this.modelPath;
        }

        public void setMarkerType(String string) {
            this.markerType = string;
        }

        public void setModelPath(String string) {
            this.modelPath = string;
        }
    }

    private static class BreakpointsStatus {
        private HashMap<String, Integer> markersStatuses = new HashMap();

        public int getSummaryStatus() {
            int maxPriority = -1;
            for (String key : this.markersStatuses.keySet()) {
                Integer status = this.markersStatuses.get(key);
                if (maxPriority >= status) continue;
                maxPriority = status;
            }
            return maxPriority;
        }

        public int getStatus(String markerType) {
            Integer status = this.markersStatuses.get(markerType);
            return status != null ? status : 0;
        }

        public void setStatusAsInt(String markerType, int status, boolean mergeStatuses) {
            Integer oldStatus = this.markersStatuses.get(markerType);
            if (oldStatus == null || oldStatus != status) {
                this.markersStatuses.put(markerType, mergeStatuses ? Integer.valueOf(status & oldStatus) : Integer.valueOf(status));
            }
        }

        public void setStatusAsInt(String markerType, int status) {
            this.setStatusAsInt(markerType, status, false);
        }

        public void setAllStatusAsInt(int status, boolean mergeStatuses) {
            for (String key : this.markersStatuses.keySet()) {
                int oldStatus = this.getStatus(key);
                this.markersStatuses.put(key, mergeStatuses ? Integer.valueOf(status & oldStatus) : Integer.valueOf(status));
            }
        }

        public void setAllStatusAsInt(int status) {
            this.setAllStatusAsInt(status, false);
        }

        public boolean containsKey(String markerType) {
            return this.markersStatuses.containsKey(markerType);
        }

        public BreakpointId[] getBreakpointIds() {
            Set<String> keySet = this.markersStatuses.keySet();
            String[] keys = keySet.toArray(new String[keySet.size()]);
            BreakpointId[] ids = new BreakpointId[keys.length];
            int i = 0;
            while (i < keys.length) {
                ids[i] = new BreakpointId(null, keys[i]);
                ++i;
            }
            return ids;
        }
    }

    private static class DiagramChangeHandler
    implements Runnable {
        private XModelObjectImpl diagramObject;
        private Integer status;
        private Thread thread;

        public void start() {
            this.thread = new Thread(this);
            this.thread.setDaemon(false);
            this.thread.start();
        }

        public DiagramChangeHandler(XModelObjectImpl diagramObject, Integer status) {
            this.diagramObject = diagramObject;
            this.status = status;
        }

        public void run() {
            this.diagramObject.fireObjectChanged((Object)this.status);
        }
    }

    private static class StatusMap {
        private HashMap<String, BreakpointsStatus> map = new HashMap();

        public void changeBreakpointStatus(String modelPath, String markerType, int status, boolean mergeStatuses) {
            BreakpointsStatus oldStatus = this.map.get(modelPath);
            if (oldStatus == null) {
                BreakpointsStatus newStatus = new BreakpointsStatus();
                newStatus.setStatusAsInt(markerType, status);
                this.map.put(modelPath, newStatus);
            } else if (markerType != null) {
                oldStatus.setStatusAsInt(markerType, status, mergeStatuses);
            } else {
                oldStatus.setAllStatusAsInt(status, mergeStatuses);
            }
        }

        public void changeBreakpointStatus(String modelPath, String markerType, int status) {
            this.changeBreakpointStatus(modelPath, markerType, status, false);
        }

        public void changeBreakpointStatus(String modelPath, int status, boolean mergeStatuses) {
            this.changeBreakpointStatus(modelPath, null, status, mergeStatuses);
        }

        public void changeAllBreakpointStatus(String modelPath, int status) {
            this.changeBreakpointStatus(modelPath, null, status);
        }

        public void changeAllBreakpointStatus(int status, boolean mergeStatuses) {
            for (String key : this.map.keySet()) {
                this.changeAllBreakpointStatus(key, status, mergeStatuses);
            }
        }

        public void changeAllBreakpointStatus(String modelPath, int status, boolean mergeStatuses) {
            this.changeBreakpointStatus(modelPath, null, status, mergeStatuses);
        }

        public void changeBreakpointStatus(BreakpointId id, int status) {
            this.changeBreakpointStatus(id.getModelPath(), id.getMarkerType(), status);
        }

        public BreakpointId[] getBreakpointIds() {
            if (this.map.size() < 1) {
                return new BreakpointId[0];
            }
            ArrayList<BreakpointId> ids = new ArrayList<BreakpointId>();
            for (String key : this.map.keySet()) {
                BreakpointId[] bIds = this.map.get(key).getBreakpointIds();
                int i = 0;
                while (i < bIds.length) {
                    bIds[i].setModelPath(key);
                    ids.add(bIds[i]);
                    ++i;
                }
            }
            return ids.toArray(new BreakpointId[ids.size()]);
        }

        public int getSummaryBreakpointStatus(String modelPath) {
            BreakpointsStatus status = this.map.get(modelPath);
            int result = status != null ? status.getSummaryStatus() : 1;
            return result;
        }

        public int getBreakpointStatus(String modelPath, String markerType) {
            BreakpointsStatus brStatus = this.map.get(modelPath);
            if (brStatus == null) {
                return 1;
            }
            return brStatus.getStatus(markerType);
        }

        public int getBreakpointStatus(BreakpointId id) {
            return this.getBreakpointStatus(id.getModelPath(), id.getMarkerType());
        }

        public boolean containsKey(String modelPath, String markerType) {
            return this.map.containsKey(modelPath) && this.map.get(modelPath).containsKey(markerType);
        }

        public boolean containsKey(BreakpointId id) {
            return this.containsKey(id.getModelPath(), id.getMarkerType());
        }

        public void clear() {
            this.map.clear();
        }

        public int getActiveBreakpointNumber(String modelPath) {
            int result = -1;
            BreakpointsStatus breakpointsStatus = this.map.get(modelPath);
            if (breakpointsStatus != null) {
                String[] markerTypes = new String[]{"org.jboss.tools.struts.debug.actionFormPopulateMarker", "org.jboss.tools.struts.debug.actionFormValidateMarker", "org.jboss.tools.struts.debug.strutsActionEnterBreakpointMarker"};
                int i = 0;
                while (i < markerTypes.length && result <= 0) {
                    if ((breakpointsStatus.getStatus(markerTypes[i]) & 8) != 0) {
                        result = i + 1;
                    }
                    ++i;
                }
            }
            return result;
        }
    }
}

