/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.PasteHandler;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.handlers.CreateConfigElementHandler;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;

public class StrutsPasteHandler
extends PasteHandler {
    Properties _p = null;
    static String ENT_ACTION_11 = "StrutsAction11";
    static String ENT_ACTION_12 = "StrutsAction12";

    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        XModelObject ref;
        if (prop == null) {
            prop = new Properties();
        }
        this._p = prop;
        if ("true".equals(prop.getProperty("secondPass"))) {
            super.executeHandler(object, prop);
            return;
        }
        XModelObject o = object.getModel().getModelBuffer().source();
        if (o != null && "StrutsProcessComment".equals(o.getModelEntity().getName())) {
            String n = XModelObjectUtil.createNewChildName((String)"comment", (XModelObject)object);
            object.getModel().getModelBuffer().copy().setAttributeValue("name", n);
            super.executeHandler(object, prop);
            this.autolayoutIfNecessary(object);
            return;
        }
        prop.setProperty("originalTarget", object.getPathPart());
        if (object instanceof ReferenceObjectImpl && (ref = ((ReferenceObjectImpl)object).getReference()) != null) {
            object = ref;
        }
        if (this.isSourceAction(object) || !this.differentStrutsFiles(object, object.getModel().getModelBuffer().source()) || this.isPasteToNavigator(prop)) {
            super.executeHandler(object, prop);
        }
        this.autolayoutIfNecessary(object);
        this._p = null;
    }

    private void autolayoutIfNecessary(XModelObject object) {
        if (this._p != null && "true".equals(this._p.getProperty("autolayout"))) {
            XModelObject process = StrutsProcessStructureHelper.instance.getProcess(object);
            StrutsProcessStructureHelper.instance.autolayout(process);
        }
    }

    private boolean isSourceAction(XModelObject object) {
        return object.getModel().getModelBuffer().source().getModelEntity().getName().startsWith("StrutsAction");
    }

    private boolean isPasteToNavigator(Properties p) {
        return p != null && "navigator".equals(p.getProperty("actionSourceGUIComponentID"));
    }

    private boolean differentStrutsFiles(XModelObject o1, XModelObject o2) {
        while (o1 != null && o1.getFileType() == 0) {
            o1 = o1.getParent();
        }
        while (o2 != null && o2.getFileType() == 0) {
            o2 = o2.getParent();
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!o1.getModelEntity().getName().startsWith("StrutsConfig")) {
            return false;
        }
        if (!o2.getModelEntity().getName().startsWith("StrutsConfig")) {
            return false;
        }
        return o1 != o2;
    }

    protected XModelObject modify(XModelObject c) {
        if (this._p == null || !this._p.containsKey("process.mouse.x")) {
            if (this._p == null) {
                this._p = new Properties();
            }
            this._p.setProperty("autolayout", "true");
            CreateConfigElementHandler.setItemShape(c, "");
        } else {
            CreateConfigElementHandler.setItemShape(c, this._p);
        }
        return c;
    }

    public boolean isEnabled(XModelObject object) {
        XModelObject ref;
        if (this.isChildPageOfProcess(object)) {
            return false;
        }
        if (super.isEnabled(object)) {
            return true;
        }
        if (object instanceof ReferenceObjectImpl && (ref = ((ReferenceObjectImpl)object).getReference()) != null) {
            return super.isEnabled(ref);
        }
        return false;
    }

    protected void pasteOnDrop(XModelObject parent, int sourceIndex, Properties p) throws XModelException {
        XModelObject o = parent.getModel().getModelBuffer().source(sourceIndex);
        String gui = p.getProperty("actionSourceGUIComponentID");
        String entity = o.getModelEntity().getName();
        if ("editor".equals(gui) && entity.startsWith("StrutsAction") && o.getParent() == parent) {
            if (o.getModelEntity().getActionList().getAction("CreateActions.CreateForward") != null) {
                XActionInvoker.invoke((String)"CreateActions.CreateForward", (XModelObject)o, (Properties)p);
            }
        } else {
            if ("editor".equals(gui) && this.insertReference(parent, entity, o, p)) {
                return;
            }
            if ("editor".equals(gui) && o.getParent() == parent && parent.getModelEntity().getName().startsWith("StrutsGlobal")) {
                XActionInvoker.invoke((String)"EditPath", (XModelObject)o, (Properties)p);
            } else if (this.isPasteToNavigator(p) && this.isParent(parent, o)) {
                super.pasteOnDrop(parent, sourceIndex, p);
            } else if (this.canAdopt(parent, o)) {
                this.drop(parent, o, p);
            } else if ("StrutsProcessComment".equals(o.getModelEntity().getName())) {
                super.pasteOnDrop(parent.getChildByPath("process"), sourceIndex, p);
            } else {
                super.pasteOnDrop(parent, sourceIndex, p);
            }
        }
    }

    protected boolean insertReference(XModelObject parent, String entity, XModelObject o, Properties p) throws XModelException {
        if (!entity.equals(ENT_ACTION_11) && !entity.equals(ENT_ACTION_12) || o.getParent() == parent) {
            return false;
        }
        XModelObject process = StrutsProcessStructureHelper.instance.getProcess(parent);
        StrutsProcessHelper h = StrutsProcessHelper.getHelper(process);
        String path = o.getAttributeValue("path");
        String module = StrutsProcessStructureHelper.instance.getProcessModule(o);
        path = module.length() == 0 ? "/" + path : StrutsProcessStructureHelper.instance.getUrlPattern(process).getContextRelativePath(path, module);
        if (h.getAction(path) != null) {
            return true;
        }
        Properties q = new Properties();
        q.setProperty("name", StrutsProcessHelper.createName(process, "action"));
        q.setProperty("type", "action");
        q.setProperty("subtype", "unknown");
        q.setProperty("path", path);
        XModelObject action = parent.getModel().createModelObject("StrutsProcessItem", q);
        CreateConfigElementHandler.setItemShape(action, p);
        DefaultCreateHandler.addCreatedObject((XModelObject)process, (XModelObject)action, (Properties)p);
        h.registerAction(action);
        return true;
    }

    private boolean isChildPageOfProcess(XModelObject object) {
        if (object == null) {
            return false;
        }
        if (!"StrutsProcess".equals(object.getModelEntity().getName())) {
            return false;
        }
        XModelBuffer buffer = object.getModel().getModelBuffer();
        int bs = buffer.getSize();
        if (bs == 0 || object == null || !object.isObjectEditable()) {
            return false;
        }
        int i = 0;
        while (i < bs) {
            String type;
            boolean b;
            XModelObject s = buffer.source(i);
            boolean bl = b = s != null && this.isParent(object, s);
            if (b && "page".equals(type = s.getAttributeValue("type"))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

